<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class simakom_transaksi
{
    //Kegiatan
    public function saveStep1()
    {
        if (isset($_POST['submitStep1'])) {
            $kategori = htmlspecialchars(trim($_POST['kategori']));
            $jenis = htmlspecialchars(trim($_POST['jenis']));
            $pajak = htmlspecialchars(trim($_POST['pajak']));
            $direct = new toast();
            echo  $direct->redirect('toast', '', 'transaksi/transaksi_create_step2');
        } else {
            echo "";
        };
    }

    public function getRefRKAS($tb_detail, $akun)
    {
        $db = database::getInstance();
        $value = $db->runQuery("SELECT * FROM  {$tb_detail}  WHERE detail_id = '$akun' ")->rowCount();
        return $value;
    }


    public function list_transaksi($tb_transaksi, $tb_detail)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_transaksi order by tanggal desc,jenis asc,  bukti asc, time asc");
        $no = 1;
        $row = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $format = new format();
            $tanggal = $format->dateToIndo($data->tanggal);
            $debet = $format->ribuan($data->debet);
            $kredit = $format->ribuan($data->kredit);
            $detail_id = $data->rkas_detail_id;
            $jenis_transaksi = $data->jenis;

            if ($jenis_transaksi == 13 || $jenis_transaksi == 14 || $jenis_transaksi == 33 || $jenis_transaksi == 34) {
                $akun = $data->pajak_akun;
            } else {
                $akun = $data->rkas_kategori . '.' . $data->rkas_kegiatan . '.' . $data->rkas_komponen . '.' . $data->rkas_akun;
            };

            $cekRefRKAS = $this->getRefRKAS($tb_detail, $detail_id);
            if ($cekRefRKAS > 0 || $jenis_transaksi == 21 ||  $jenis_transaksi == 22 || $jenis_transaksi == 13 || $jenis_transaksi == 14 || $jenis_transaksi == 33 || $jenis_transaksi == 34 || $jenis_transaksi > 40) {
                $warningNoRef = "#FFFFFF";
                // $warningNoRef = "#E9967A";
                // $link = new linkpage();
                // $edit = " <a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a>";
            } else {
                //$warningNoRef = "#FFFFFF";
                $warningNoRef = "#E9967A";
                // $link = new linkpage();
                // $edit = " <a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a>";
            };

            $link = new linkpage();


            if ($jenis_transaksi == 31 || $jenis_transaksi == 32 || $jenis_transaksi == 35 || $jenis_transaksi == 36 || $jenis_transaksi == 43 || $jenis_transaksi == 44 || $jenis_transaksi == 45 || $jenis_transaksi == 46) {
                $printKuitansi = "<a " . $link->pageID($data->id, 'transaksi/kuitansi_printpreview') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-printer'></i> CETAK</a>";
            } else {
                $printKuitansi = "";
            };


            echo "
                    <tr bgcolor=$warningNoRef >
                        <td width='5px'>
                            <input type='checkbox' class='d-inline small chk_boxes1' name='id_trans[]' value='" . $data->no . "'> 
                        </td>
                        <td width='75px' align='center'><a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a></td>
                  
                        <td align=left>$data->bukti</td>
                        <td align=left>$tanggal</td>
                        <td align=left>$data->uraian</td>
                        <td align=left>$debet</td>
                        <td align=left>$kredit</td>
                        <td align=left>$data->jenis</td>
                        <td align=left>$akun</td>
                        <td width='75px' align='center'>$printKuitansi</td>
                    </tr>";
        }
    }


    //Detail/Rincian
    public function insertTransaksi($tahun, $tb_revisi, $tb_transaksi)
    {
        $csrf = new csrf();
        $csrf = $csrf->cekToken();

        $bukti = htmlspecialchars($_POST['bukti']);
        $bukti_sistem = $this->maxBukti($tb_transaksi) + 100000;

        $format = new format();
        $tanggal = $format->dateToEng(htmlspecialchars($_POST['tanggal']));

        $uraian = htmlspecialchars(trim($_POST['uraian']));
        $jumlah = htmlspecialchars($_POST['jumlah']);

        $cekissetPost = new cekissetPost;
        $penerima = $cekissetPost->cek('penerima');
        $penerima_jabatan = $cekissetPost->cek('penerima_jabatan');
        //$penerima = htmlspecialchars($_POST['penerima']);
        //$penerima_jabatan = htmlspecialchars($_POST['penerima_jabatan']);

        $kategori_transaksi = htmlspecialchars($_POST['kategori_transaksi']);
        $jenis_transaksi = htmlspecialchars($_POST['jenis_transaksi']);
        $pajak_transaksi = htmlspecialchars($_POST['pajak_transaksi']);

        $rkas_kategori = htmlspecialchars(trim($_POST['rkas_kategori']));
        $rkas_kegiatan = htmlspecialchars(trim($_POST['rkas_kegiatan']));
        $rkas_komponen = htmlspecialchars(trim($_POST['rkas_komponen']));

        $rkas_akun =  $cekissetPost->cekIf('rkas_akun', '00000');
        $rkas_pembiayaan_id = htmlspecialchars(trim($_POST['rkas_pembiayaan_id']));
        $rkas_pembiayaan_kegiatan = htmlspecialchars(trim($_POST['rkas_pembiayaan_kegiatan']));
        $rkas_pembiayaan_akun = htmlspecialchars(trim($_POST['rkas_pembiayaan_akun']));
        $rkas_pembiayaan_komponen = htmlspecialchars(trim($_POST['rkas_pembiayaan_komponen']));
        $rkas_detail_id = htmlspecialchars(trim($_POST['detail_id']));

        //Input Debet/Kredit
        $class = new simakom_transaksi();

        if ($class->uraianRKAS('simakom_ref_jenisbelanja', 'kode', $jenis_transaksi, 'debet') == 1) {
            $debet = $jumlah;
        } else {
            $debet = 0;
        };
        if ($class->uraianRKAS('simakom_ref_jenisbelanja', 'kode', $jenis_transaksi, 'kredit') == 1) {
            $kredit = $jumlah;
        } else {
            $kredit = 0;
        };

        if ((trim($pajak_transaksi) != 0 || trim($pajak_transaksi) != "") && ($jenis_transaksi == 13 || $jenis_transaksi == 14 || $jenis_transaksi == 33 || $jenis_transaksi == 34)) {
            $pajak = 1;
            $pajak_akun = $pajak_transaksi;
        } else {
            $pajak = 0;
            $pajak_akun = "";
        };


        $class_time = new time();
        $time = $class_time->getTime();

        $revisi = $this->maxRevisi($tb_revisi);

        $id = substr(md5($jenis_transaksi), 6, 3) . substr(md5($time), 0, 4) . substr(md5($jumlah), 3, 4) . substr(md5($revisi), 5, 7) . substr(md5($rkas_pembiayaan_akun) . 5, 7) . substr(md5($rkas_pembiayaan_kegiatan), 5, 7);

        $crud = new crudData();
        $array = [
            'tanggal' => $tanggal,
            'bukti' => $bukti,
            'bukti_sistem' => $bukti_sistem,
            'jenis' => $jenis_transaksi,
            'kategori' => $kategori_transaksi,
            'rkas_kategori' => $rkas_kategori,
            'rkas_kegiatan' => $rkas_kegiatan,
            'rkas_komponen' => $rkas_komponen,
            'rkas_akun' => $rkas_akun,
            'rkas_detail_id' => $rkas_detail_id,
            'uraian' => $uraian,
            'debet' => $debet,
            'kredit' => $kredit,
            'penerima' => $penerima,
            'penerima_jabatan' => $penerima_jabatan,
            'pembiayaan_id' => $rkas_pembiayaan_id,
            'pembiayaan_kegiatan' => $rkas_pembiayaan_kegiatan,
            'pembiayaan_komponen' => $rkas_pembiayaan_komponen,
            'pembiayaan_akun' => $rkas_pembiayaan_akun,
            'pajak' => $pajak,
            'pajak_akun' => $pajak_akun,
            'revisi' => $revisi,
            'id_Setor' => '',
            'time' => $time,
            'id' => $id
        ];

        $cekTanggal = $this->blokTanggal($tahun, $tanggal); //Blok Transaksi di Luar Tanggal Periode
        if ($cekTanggal == true) {
            $save = $crud->insertData($tb_transaksi, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'transaksi/transaksi_read');
        } else {
            $direct = new toast();
            echo  $direct->redirect('toast', 'blokTanggal', 'transaksi/transaksi_read');
        };
    }

    public function simReport()
    {
        $servroot = $_SERVER['DOCUMENT_ROOT'];
        $simreport = new simakom_laporan;
        if ($simreport->sxatx() == true) {
            echo "";
        } elseif ($simreport->sxatx() == false && (file_exists($servroot . "/lisensi/index.php") || file_exists("../../../lisensi/index.php"))) {
            echo "<script>window.location='../../../lisensi/'</script>";
        } elseif ($simreport->sxatx() == false && (file_exists($servroot . "/lisensi/index.php") || file_exists("../../lisensi/index.php"))) {
            echo "<script>window.location='../../lisensi/'</script>";
        } elseif ($simreport->sxatx() == false && (file_exists($servroot . "/lisensi/index.php") || file_exists("../lisensi/index.php"))) {
            echo "<script>window.location='../lisensi/'</script>";
        } else {
            echo "<script>window.location='./lisensi/'</script>";
        }
    }
    public function simReportLisen()
    {
        // $servroot = $_SERVER['DOCUMENT_ROOT'];
        $simreport = new simakom_laporan;
        if ($simreport->sxatx() == true) {
            echo "<script>window.location='../'</script>";
        } else {
            echo "<script>window.location='./'</script>";
        }
    }

    public function updateTransaksi($id, $tahun, $tb_revisi, $tb_transaksi)
    {
        $csrf = new csrf();
        $cekissetPost = new cekissetPost;
        $csrf = $csrf->cekToken();

        $bukti = htmlspecialchars($_POST['bukti']);
        $bukti_sistem = $this->maxBukti($tb_transaksi) + 100000;

        $format = new format();
        $tanggal = $format->dateToEng(htmlspecialchars($_POST['tanggal']));


        $uraian = htmlspecialchars(trim($_POST['uraian']));
        $jumlah = htmlspecialchars($_POST['jumlah']);

        $cekIsset = new cekissetPost();
        $penerima = $cekIsset->cek('penerima');
        $penerima_jabatan = $cekIsset->cek('penerima_jabatan');

        //$penerima = htmlspecialchars($_POST['penerima']);
        //$penerima_jabatan = htmlspecialchars($_POST['penerima_jabatan']);

        $kategori_transaksi = htmlspecialchars($_POST['kategori_transaksi']);
        $jenis_transaksi = htmlspecialchars($_POST['jenis_transaksi']);
        $pajak_transaksi = htmlspecialchars($_POST['pajak_transaksi']);

        $rkas_pembiayaan_id = htmlspecialchars(trim($_POST['rkas_pembiayaan_id']));
        $rkas_kategori = htmlspecialchars(trim($_POST['rkas_kategori']));
        $rkas_kegiatan = htmlspecialchars(trim($_POST['rkas_kegiatan']));
        $rkas_komponen = htmlspecialchars(trim($_POST['rkas_komponen']));
        // $rkas_akun = htmlspecialchars(trim($_POST['rkas_akun']));
        $rkas_akun =  $cekissetPost->cekIf('rkas_akun', '00000');
        $rkas_pembiayaan_kegiatan = htmlspecialchars(trim($_POST['rkas_pembiayaan_kegiatan']));
        $rkas_pembiayaan_akun = htmlspecialchars(trim($_POST['rkas_pembiayaan_akun']));
        $rkas_pembiayaan_komponen = htmlspecialchars(trim($_POST['rkas_pembiayaan_komponen']));
        $rkas_detail_id = htmlspecialchars(trim($_POST['detail_id']));

        //Input Debet/Kredit
        $class = new simakom_transaksi();

        if ($class->uraianRKAS('simakom_ref_jenisbelanja', 'kode', $jenis_transaksi, 'debet') == 1) {
            $debet = $jumlah;
        } else {
            $debet = 0;
        };
        if ($class->uraianRKAS('simakom_ref_jenisbelanja', 'kode', $jenis_transaksi, 'kredit') == 1) {
            $kredit = $jumlah;
        } else {
            $kredit = 0;
        };

        if ((trim($pajak_transaksi) != 0 || trim($pajak_transaksi) != "")  && $jenis_transaksi < 41) {
            $pajak = 1;
        } else {
            $pajak = 0;
        };

        $class_time = new time();
        $time = $class_time->getTime();

        $revisi = $this->maxRevisi($tb_revisi);
        if (isset($_POST['updateTransaksi'])) {
            $array = [
                'tanggal' => $tanggal,
                'bukti' => $bukti,
                'bukti_sistem' => $bukti_sistem,
                'jenis' => $jenis_transaksi,
                'kategori' => $kategori_transaksi,
                'rkas_kategori' => $rkas_kategori,
                'rkas_kegiatan' => $rkas_kegiatan,
                'rkas_komponen' => $rkas_komponen,
                'rkas_akun' => $rkas_akun,
                'rkas_detail_id' => $rkas_detail_id,
                'uraian' => $uraian,
                'debet' => $debet,
                'kredit' => $kredit,
                'penerima' => $penerima,
                'penerima_jabatan' => $penerima_jabatan,
                'pembiayaan_id' => $rkas_pembiayaan_id,
                'pembiayaan_kegiatan' => $rkas_pembiayaan_kegiatan,
                'pembiayaan_komponen' => $rkas_pembiayaan_komponen,
                'pembiayaan_akun' => $rkas_pembiayaan_akun,
                'pajak' => $pajak,
                'pajak_akun' => $pajak_transaksi,
                'revisi' => $revisi,
                'time' => $time,
                'id' => $id

            ];


            $cekTanggal = $this->blokTanggal($tahun, $tanggal); //Blok Transaksi di Luar Tanggal Periode
            if ($cekTanggal == true) {
                $crud = new crudData();
                $update = $crud->updateData($tb_transaksi, $array, ['id', ' = ', $id]);
                $direct = new toast();
                echo  $direct->redirect('toast', 'update', 'transaksi/transaksi_read');
            } else {
                $direct = new toast();
                echo  $direct->redirect('toast', 'blokTanggal', 'transaksi/transaksi_read');
            }
        } else {
            echo "";
        };
    }

    public function blokTanggal($tahun, $tanggal)
    {
        if ($tanggal >= substr($tahun, 0, 4) . '-07-01' && $tanggal <= substr($tahun, 5, 4) . '-06-30') {
            $value = true;
        } else {
            $value = false;
        }
        return $value;
    }

    //LIST KATEGORI
    public function list_kategori($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi,  $pajak, $kategori, $showSelect, $tb_kegiatan,  $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM simakom_ref_kategori where kategori='$showSelect' order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian = $data->uraian;

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $this->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            if ($kategori_kode == "C") {
                $jumlah = $saldo_format;
            } else {
                $jumlah = $jumlah_format;
            };

            echo "
            <tr bgcolor=#FFFFFF>
                <td width='5px'><b class='text-danger pl-1'><b>$kategori_kode</b></td>
                <td align=left ><b class='text-danger'><b>$kategori_uraian</b></td>
                <td align=right><b class='text-danger'><b>$jumlah</b></td>
                <td align=right><b class='text-danger'><b>$pd_format</b></td>
                <td align=right><b class='text-danger'><b>$surplus_format</b></td>
                <td width='50px' align='left' class='text-danger'></td>
            </tr>
			";
            $this->list_kegiatan($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori_kode, $tb_revisi);
            $no++;
        }
    }

    //LIST KEGIATAN
    public function list_kegiatan($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak,  $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori, $tb_revisi)
    {

        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kategori = '{$kategori}' and revisi='$revisi' group by kegiatan order by kegiatan asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kegiatan_kode = $data->kegiatan;
            $kegiatan_uraian = $data->uraian;
            $kategori_kode = $data->kategori;
            $kegiatan_id = $data->id;

            //Kode Custome
            $kegiatan_custome = $this->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'kegiatan_custome');


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode' and kegiatan='$kegiatan_kode' and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kegiatan_kode' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
					<tr bgcolor=#FFFFFF>
						<td align=left><b class='text-primary pl-2'><b>$kegiatan_custome</b></td>
						<td align=left ><b class='text-primary pl-1'><b>$kegiatan_uraian</b></td>
                        <td align=right><b class='text-primary'><b>$jumlah_format</b></td>
                        <td align=right><b class='text-primary'><b>$pd_format</b></td>
                        <td align=right><b class='text-primary'><b>$surplus_format</b></td>
						<td align=left></td>
					</tr>
					";
            $this->list_komponen($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $kegiatan_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST KOMPONEN
    public function list_komponen($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE kegiatan = '{$kegiatan}'  and revisi='$revisi' group by komponen  order by komponen asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $komponen_kode = $data->komponen;
            $komponen_uraian = $data->uraian;
            $kode_kegiatan = $data->kegiatan;
            $komponen_id = $data->id;

            //Uraian Kegiatan
            $showkegiatan = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kegiatan = '{$kode_kegiatan}'");
            $kegiatan = $showkegiatan->fetch(PDO::FETCH_OBJ);
            $kegiatan_uraian = $kegiatan->uraian;
            $kode_kategori = $kegiatan->kategori;
            $kegiatan = $kegiatan->kegiatan;
            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  --   ' . $kode_kegiatan .  ' : ' . $kegiatan_uraian;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$komponen_kode'  and revisi='$revisi' ");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };


            echo "
                 <tr bgcolor='#FFFFFF' title='$title_kegiatan'>
                     <td align=left><b class='text-info pl-4'><b>$komponen_kode</b></td>
                     <td align=left ><b class='text-info pl-1'><b>$komponen_uraian</b></td>
                     <td align=right><b class='text-info'><b>$jumlah_format</b></td>
                     <td align=right><b class='text-info'><b>$pd_format</b></td>
                     <td align=right><b class='text-info'><b>$surplus_format</b></td>
                     <td align=left></td>
                 </tr>
                 ";
            $this->list_akun($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kode_kegiatan, $komponen_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST AKUN
    public function list_akun($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE kegiatan = '{$kegiatan}' and komponen='$komponen'  and revisi='$revisi' group by akun  order by akun asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun_id = $data->id;
            $akun_kode = $data->akun;
            $akun_uraian = $data->uraian;
            $kode_kategori = $data->kategori;
            $kode_kegiatan = $data->kegiatan;
            $kode_komponen = $data->komponen;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'akun_custome');

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kode_kegiatan, 'uraian');
            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'komponen', $kode_komponen, 'uraian');

            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kode_kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $kode_komponen . ' : ' . $uraian_komponen;


            //$classlinkpost = new linkpost();
            // $pilih = $classlinkpost->SelectAkun($id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $akun_id, 'transaksi/transaksi_create_step2', '', 'bookmark-check', 'primary');
            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$kode_komponen' and akun='$akun_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$kode_komponen' and pembiayaan_akun='$akun_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };


            echo "
                 <tr bgcolor='#FFFFFF' title='$title_kegiatan'>
                     <td align=left><b class='text-secondary pl-5'><b>$akun_custome</b></td>
                     <td align=left ><b class='text-secondary pl-1'><b>$akun_uraian</b></td>
                     <td align=right><b class='text-secondary'><b>$jumlah_format</b></td>
                     <td align=right><b class='text-secondary'><b>$pd_format</b></td>
                     <td align=right><b class='text-secondary'><b>$surplus_format</b></td>
                     <td align=left></td>
                 </tr>
                 ";
            $this->list_detail($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $akun_id, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi);
            $no++;
        }
    }

    //LIST DETAIL
    public function list_detail($src, $pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $akun_id, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_detail WHERE  kategori='{$kode_kategori}' and kegiatan='{$kode_kegiatan}' and komponen='$kode_komponen' and akun = '{$akun_kode}' and revisi='$revisi'  order by detail asc, time asc");
        $no = 1;
        $row = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun = $data->akun;
            $id_detail = $data->id;
            $detail_uraian = $data->uraian;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun, 'akun_custome');

            $akun_uraian = $data->uraian;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;

            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $detail = $data->detail;
            $detail_id = $data->detail_id;
            $uraian = $data->uraian;
            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;

            $viewPerh = $this->viewPerhitungan($komponen_1, $komponen_2, $komponen_3, $komponen_4, $unit_1, $unit_2, $unit_3, $unit_4);
            $uraian_detail = $detail_uraian . ' ' . $viewPerh;

            $volume = @(number_format($data->volume, 0, ",", "."));
            $unit = $data->unit;
            $harga = @(number_format($data->satuan, 0, ",", "."));

            $total = number_format($data->total, 0, ",", ".");
            $pembiayaan_kegiatan = $data->pembiayaan_kegiatan;
            $pembiayaan_komponen = $data->pembiayaan_komponen;
            $pembiayaan_akun = $data->pembiayaan_akun;

            $pembiayaan = $pembiayaan_kegiatan . '.' . $pembiayaan_komponen . '.' . $pembiayaan_akun;
            if ($kategori == "A") {
                $kode_pembiayaan = "";
            } else {
                $kode_pembiayaan = $pembiayaan;
            };

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kegiatan, 'uraian');

            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'kode_id', $kategori . $kegiatan . $komponen, 'uraian');

            $uraian_akun = $this->uraianRKAS($tb_akun, 'akun', $akun, 'uraian');
            $title_akun = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $komponen . ' : ' . $uraian_komponen . ' - ' . $akun_custome . ' : ' . $uraian_akun;

            $classlinkpost = new linkpost();

            //Source Create or Update
            if ($src == "C") {
                $pilih = $classlinkpost->SelectAkun($id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $akun, $detail_id, 'transaksi/transaksi_create_step2', '', 'bookmark-check', 'primary');
            } else {
                $pilih = $classlinkpost->SelectAkunEdit($pageID, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $akun, $detail_id, 'transaksi/transaksi_edit', '', 'bookmark-check', 'primary');
            };
            // $showList = $class->list_kategori($src, $page_id, $id_transaksi, $kategori_transaksi, $jenis_transaksi, $pajak, $kategori, $showSelect, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi);

            $link = new linkpage();
            //$xxx = " <a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-primary  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a>";


            $rowdetail = $akun_custome . '.' . $row++;

            echo "
              <tr bgcolor=#FFFFFF height='10' title='$title_akun'>
                  <td align=left></td>
                  <td align=left><span class='pl-1'><i>$rowdetail - $uraian_detail</i></span></td>
                  <td align=right>$total</td>
                  <td align=left>$kode_pembiayaan</td>
                  <td align=right></td>
                  <td align=left>$pilih</td>
              </tr>
              ";
            $no++;
        }
    }

    public function maxRevisi($tb_revisi)
    {
        $db = database::getInstance();
        $sql = $db->runQuery("SELECT max(revisi) as maksimal FROM {$tb_revisi}");
        $max = $sql->fetch();
        $value = $max['maksimal'];
        return $value;
    }

    public function maxBukti($tb_transaksi)
    {
        $db = database::getInstance();
        $sql = $db->runQuery("SELECT max(bukti) as maksimal FROM {$tb_transaksi}");
        $max = $sql->fetch();
        $value = @($max['maksimal'] + 100000);
        return $value;
    }

    //JUmlah / SUM
    public function sum($tabel, $field, $kondisi)
    {
        $db = database::getInstance();
        $query = $db->runQuery("SELECT SUM({$field}) FROM {$tabel} {$kondisi}");
        $query->execute();
        $data_sum = $query->fetch();
        $value = $data_sum[0];
        return $value;
    }
    public function uraianRKAS($tabel, $key, $id, $field)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tabel}  WHERE {$key}= '{$id}'");
        $uraian = $show->fetch(PDO::FETCH_OBJ);
        $value = $uraian->$field;
        return $value;
    }
    public function cekValue($tabel, $key, $id, $field)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tabel}  WHERE {$key}= '{$id}'");
        $uraian = $show->fetch(PDO::FETCH_OBJ);
        $value = $uraian->$field;
        return $value;
    }
    public function uraianPajak($pajak)
    {
        if ($pajak == 411121) {
            $value = "PPh Pasal 21";
        } elseif ($pajak == 411122) {
            $value = "PPh Pasal 22";
        } elseif ($pajak == 411124) {
            $value = "PPh Pasal 23";
        } elseif ($pajak == 411128) {
            $value = "PPh Pasal 4";
        } elseif ($pajak == 411211) {
            $value = "PPN";
        };
        return $value;
    }

    public function rekomUraianPajak($jenis_transaksi, $pajak_transaksi)
    {
        if ($jenis_transaksi == 13 || $jenis_transaksi == 14) {
            $uraian_rekomendasi = "Terima pungutan " . $this->uraianPajak($pajak_transaksi);
        } elseif ($jenis_transaksi == 33 || $jenis_transaksi == 34) {
            $uraian_rekomendasi = "Bayar " . $this->uraianPajak($pajak_transaksi);
        } else {
            $uraian_rekomendasi = "NR";
        };
        return $uraian_rekomendasi;
    }


    public function rekomUraianNonPajak($jenis_transaksi, $tb_detail, $detail_id_transaksi)
    {
        if ($jenis_transaksi == 15 || $jenis_transaksi == 16) {
            $uraian_rekomendasi = "Terima Pengembalian " . $this->uraianRKAS($tb_detail, 'detail_id', $detail_id_transaksi, 'uraian');
        } elseif ($jenis_transaksi == 35 || $jenis_transaksi == 36) {
            $uraian_rekomendasi = "Pengembalian Pendapatan  " . $this->uraianRKAS($tb_detail, 'detail_id', $detail_id_transaksi, 'uraian');
        } elseif ($jenis_transaksi == 11 || $jenis_transaksi == 12) {
            $uraian_rekomendasi = "Terima  " . $this->uraianRKAS($tb_detail, 'detail_id', $detail_id_transaksi, 'uraian');
        } elseif ($jenis_transaksi == 31 || $jenis_transaksi == 32) {
            $uraian_rekomendasi = "Belanja  " . $this->uraianRKAS($tb_detail, 'detail_id', $detail_id_transaksi, 'uraian');
        } elseif ($jenis_transaksi == 21) {
            $uraian_rekomendasi = "Setor Tunai ke Bank";
        } elseif ($jenis_transaksi == 22) {
            $uraian_rekomendasi = "Tarik Tunai dari Bank";
        };
        return $uraian_rekomendasi;
    }

    public function kodeCustome($tabel, $key, $id, $field)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tabel}  WHERE {$key}= '{$id}'");
        $cust = $show->fetch(PDO::FETCH_OBJ);
        $value = $cust->$field;
        return $value;
    }
    public function viewPerhitungan($kom1, $kom2, $kom3, $kom4, $unit1, $unit2, $unit3, $unit4)
    {
        if ($kom1 == '' && $unit1 == '') {
            $value1 = "";
        } else {
            $value1 = $kom1 . ' ' . $unit1;
        };
        if ($kom2 == '' && $unit2 == '') {
            $value2 = "";
        } else {
            $value2 = ' x ' . $kom2 . ' ' . $unit2;
        };
        if ($kom3 == '' && $unit3 == '') {
            $value3 = "";
        } else {
            $value3 = ' x ' . $kom3 . ' ' . $unit3;
        };
        if ($kom4 == '' && $unit4 == '') {
            $value4 = "";
        } else {
            $value4 = ' x ' . $kom4 . ' ' . $unit4;
        };

        if ($kom1 == "" and $kom2 == "" and $kom3 == "" and $kom4 == "" and $unit1 == "" and $unit2 == "" and $unit3 == "" and $unit4 == "") {
            $value = "";
        } else {
            $value = "[" . $value1 . $value2 . $value3 . $value4 . "]";
        };

        return $value;
    }
    public function penandaTangan_Kuitansi($tanggal, $tahun)
    {
        $clssekolah = new sekolah();

        $simakom_bendahara_nama = $clssekolah->dataSekolah('simakom_bendahara_nama');
        $simakom_bendahara_nip = $clssekolah->dataSekolah('simakom_bendahara_nip');
        $simakom_atasan_nama = $clssekolah->dataSekolah('simakom_atasan_nama');
        $simakom_atasan_nip = $clssekolah->dataSekolah('simakom_atasan_nip');
        $simakom_atasan_jabatan = $clssekolah->dataSekolah('simakom_atasan_jabatan');

        $format = new format();

        $tanggal = $format->dateToIndoLong($tanggal);


        echo "
                <dl class='row'>
                    <dd class='col-sm-8'>Mengetahui,<br>$simakom_atasan_jabatan</dd>
                    <dd class='col-sm-4'>Lunas dibayar tanggal $tanggal<br>Bendahara</dd>    
                    <dd class='col-sm-8 mt-5'>$simakom_atasan_nama<br>NIP. $simakom_atasan_nip</dd>
                    <dd class='col-sm-4 mt-5'>$simakom_bendahara_nama<br>NIP. $simakom_bendahara_nip</dd>                 
                </dl>
             ";
    }
}
