<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class simakom_neraca extends simakom_laporan
{
    public function summaryAset($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun)
    {
        $asetTetap = $this->summaryAsetTetap($tb_jurnal, $periode, $tahun);
        $asetLancar = $this->summaryAsetLancar($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun);
        $asetLainnya = $this->summaryAsetLainnya($tb_siswa, $tb_transaksi_aks, $tb_jurnal, $periode, $tahun);
        $aset = $asetLainnya + $asetTetap + $asetLancar;
        return $aset;
    }

    //ASet tetap
    public function summaryAsetTetap($tb_jurnal, $periode, $tahun)
    {
        $asetTetap = $this->sumNeraca($tb_jurnal, '1',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '2',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '3',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '4',  $periode, $tahun);
        return $asetTetap;
    }

    //Aset Lancar
    public function summaryAsetLancar($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun)
    {
        $kas = $this->summarySABKU($tb_transaksi, $periode, $tahun);
        $asetLancar = $this->sumNeraca($tb_jurnal, '5',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '6',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '7',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '8',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '9',  $periode, $tahun);
        $belumSetor = $this->belumSetor($tb_transaksi_aks);
        $piutang = $this->summarySAPiutang($tb_transaksi, $periode, $tahun);
        $aset = $kas  + $asetLancar + $belumSetor + $piutang;
        return $aset;
    }

    //Aset Lainnya
    public function summaryAsetLainnya($tb_siswa, $tb_transaksi_aks, $tb_jurnal, $periode, $tahun)
    {
        $asetLainn = $this->sumNeraca($tb_jurnal, '10',  $periode, $tahun) + $this->sumNeraca($tb_jurnal, '11',  $periode, $tahun);
        $belumBayar = $this->tanggunganbelumDibayar($tb_siswa, $tb_transaksi_aks);
        $aset = $belumBayar + $asetLainn;
        return $aset;
    }

    //Kewajiban
    public function summaryKewajiban($tb_transaksi, $tb_jurnal, $periode, $tahun)
    {
        $KewajibanPihakLain = $this->summaryKewajibanPihakLain($tb_transaksi,  $tb_jurnal, $periode, $tahun);
        $KewajibanLain = $this->summaryKewajibanLainnya($tb_jurnal, $periode, $tahun);
        $aset = $KewajibanPihakLain + $KewajibanLain;
        return $aset;
    }

    public function summaryKewajibanPihakLain($tb_transaksi,  $tb_jurnal, $periode, $tahun)
    {
        $kewajiban = $this->summarySAHutang($tb_transaksi, $periode, $tahun) + $this->sumNeraca($tb_jurnal, '12',  $periode, $tahun);
        $pajak = $this->summarySAPajak($tb_transaksi, $periode, $tahun) + $this->sumNeraca($tb_jurnal, '13',  $periode, $tahun);
        $wajib = $kewajiban + $pajak;
        return $wajib;
    }
    public function summaryKewajibanLainnya($tb_jurnal, $periode, $tahun)
    {
        $kewajiban = $this->sumNeraca($tb_jurnal, '14',  $periode, $tahun);
        return $kewajiban;
    }

    public function sumNeraca($tb_jurnal, $jenis, $periode, $tahun)
    {
        //Jumlah Akhir bulan Lalu
        $rangePeriode = $this->rangePeriode($periode, $tahun, 'tanggal');

        $tanggal = $this->ValPeriodeBuku($periode, $tahun) . '-01';
        $db = database::getInstance();
        $q_jmlLalu = $db->runQuery("SELECT SUM(jumlah) FROM {$tb_jurnal} where tanggal <'$tanggal' and jenis='$jenis'");
        $q_jmlLalu->execute();
        $d_jmlLalu = $q_jmlLalu->fetch();
        $jmlLalu = $d_jmlLalu[0];

        $intBulan = $this->ValPeriodeBuku($periode, $tahun);

        $q_jumlah = $db->runQuery("SELECT SUM(jumlah) FROM {$tb_jurnal} where $rangePeriode and jenis='$jenis'");
        $q_jumlah->execute();
        $d_jumlah = $q_jumlah->fetch();
        $jumlah = $d_jumlah[0];

        $value = $jmlLalu + $jumlah;
        return $value;
    }


    public function summaryEkuitas($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun)
    {
        $aset = $this->summaryAset($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun);
        $kewajiban = $this->summaryKewajiban($tb_transaksi, $tb_jurnal, $periode, $tahun);
        $ekuitas = $aset - $kewajiban;
        return $ekuitas;
    }
    public function tagihkanPihakketiga($tb_siswa, $tb_transaksi, $tb_transaksi_aks, $periode, $tahun)
    {
        $piutang = $this->summarySAPiutang($tb_transaksi, $periode, $tahun);
        $belumBayar = $this->tanggunganbelumDibayar($tb_siswa, $tb_transaksi_aks);
        $belumSetor = $this->belumSetor($tb_transaksi_aks);

        $sumKewajiban = $piutang + $belumBayar + $belumSetor;
        return $sumKewajiban;
    }

    //Tanggungan Siswa
    public function tanggunganbelumDibayar($tb_siswa, $tb_transaksi)
    {
        //Query Tanggungan
        $classTanggungan = new listTanggungan();
        $val_sumtang = $classTanggungan->sumTanggunganByFilter($tb_siswa, 'Semua', 'Semua', 'Semua');
        $classTrans = new transaksi();
        $terbayar = $classTrans->sumTerbayar($tb_transaksi, 'Semua', 'Semua', 'Semua');
        $kurang = $val_sumtang - $terbayar;
        return $kurang;
    }
    public function belumSetor($tb_transaksi)
    {
        $clsSetor = new setor;
        $value = $clsSetor->jumlah($tb_transaksi, 'jumlah', " where setor=''");
        return $value;
    }

    public function listJurnal()
    {
        $periode = "
                <option value='1'> Aset Tetap - Tanah </option>
                <option value='2'> Aset Tetap - Gedung & Bangunan </option>
                <option value='3'> Aset Tetap - Peralatan & Mesin </option>
                <option value='4'> Aset Tetap - Lainnya </option>
                <option value='5'> Aset Lancar - Persediaan </option>
                <option value='6'> Aset Lancar - Kas Tunai </option>
                <option value='7'> Aset Lancar - Kas Bank </option>
                <option value='8'> Aset Lancar - Piutang </option>
                <option value='9'> Aset Lancar - Penerimaan belum disetor </option>
                <option value='10'> Aset Lainnya - Tanggungan belum dibayar </option>
                <option value='11'> Aset Lainnya - Lainnya </option>
                <option value='12'> Kewajiban - Hutang </option>
                <option value='13'> Kewajiban - Pungutan Pajak belum dibayar/disetor </option>
                <option value='14'> Kewajiban - Lainnya </option>
                ";
        return $periode;
    }

    public function cpy($from, $to)
    {
        $servroot = $_SERVER['DOCUMENT_ROOT'];
        $servweb = $_SERVER['HTTP_HOST'];

        if (file_exists($servroot . $from) || file_exists($from)) {
            $cpy = copy($from, $to);
        } else {
            $cpy = "";
        };

        // $cpy = copy($from, $to);
        return $cpy;
    }
    public function cpy_ekstrak($file)
    {
        //$file = '../../app.zip';
        $path = pathinfo(realpath($file), PATHINFO_DIRNAME);
        $zip = new ZipArchive;
        $res = $zip->open($file);
        if ($res === TRUE) {
            $zip->extractTo($path);
            $zip->close();
            unlink($file);
        }
    }
    public function valueJurnal($jenis)
    {
        if ($jenis == 1) {
            $value = "Aset Tetap - Tanah";
        } elseif ($jenis == 2) {
            $value = "Aset Tetap - Gedung & Bangunan";
        } elseif ($jenis == 3) {
            $value = "Aset Tetap - Peralatan & Mesin";
        } elseif ($jenis == 4) {
            $value = "Aset Tetap - Lainnya";
        } elseif ($jenis == 5) {
            $value = "Aset Lancar - Persediaan";
        } elseif ($jenis == 6) {
            $value = "Aset Lancar - Kas Tunai";
        } elseif ($jenis == 7) {
            $value = "Aset Lancar - Kas Bank";
        } elseif ($jenis == 8) {
            $value = "Aset Lancar - Piutang";
        } elseif ($jenis == 9) {
            $value = "Aset Lancar - Penerimaan belum disetor";
        } elseif ($jenis == 10) {
            $value = "Aset Lainnya - Tanggungan belum dibayar";
        } elseif ($jenis == 11) {
            $value = "Aset Lainnya - Lainnya";
        } elseif ($jenis == 12) {
            $value = "Kewajiban - Hutang";
        } elseif ($jenis == 13) {
            $value = "Kewajiban - Pungutan Pajak belum dibayar/disetor";
        } elseif ($jenis == 14) {
            $value = "Kewajiban - Lainnya";
        } else {
            $value = "#REf";
        };

        return $value;
    }

    public function trJurnal($title, $textColor, $font, $pl, $nilai)
    {
        $format = new format;
        if ($font == "b") {
            $title = "<b>" . $title . "</b>";
            $nilai = "<b>" . $format->ribuan($nilai) . "</b>";
        } elseif ($font == "i") {
            $title = "<i>" . $title . "</i>";
            $nilai = "<i>" . $format->ribuan($nilai) . "</i>";
        } else {
            $title = $title;
            $nilai =  $format->ribuan($nilai);
        };

        $tr = "<tr>
            <td align=left valign='middle'><span class='pl-$pl $textColor'>$title</span></td>
            <td align=right valign='middle' width='200'><span class='$textColor'>" . $nilai . "</span></td>
        </tr>";
        return $tr;
    }
    public function viewJurnal($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun)
    {
        //Aset Tetap
        echo $this->trJurnal('Aset', 'text-primary', 'b', 0, $this->summaryAset($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Aset Tetap', 'text-secondary', 'b', 3, $this->summaryAsetTetap($tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Tanah', '', '', 4, $this->sumNeraca($tb_jurnal, '1',  $periode, $tahun));
        echo $this->trJurnal('Gedung & Bangunan', '', '', 4, $this->sumNeraca($tb_jurnal, '2',  $periode, $tahun));
        echo $this->trJurnal('Peralatan & Mesin', '', '', 4, $this->sumNeraca($tb_jurnal, '3',  $periode, $tahun));
        echo $this->trJurnal('Aset Tetap Lainnya', '', '', 4, $this->sumNeraca($tb_jurnal, '4',  $periode, $tahun));

        echo $this->trJurnal('Aset Lancar', 'text-secondary', 'b', 3, $this->summaryAsetLancar($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Persediaan', '', '', 4, $this->sumNeraca($tb_jurnal, '5',  $periode, $tahun));
        echo $this->trJurnal('Kas Tunai', '', '', 4, $this->summarySATunai($tb_transaksi, $periode, $tahun));
        echo $this->trJurnal('Kas Bank', '', '', 4, $this->summarySABank($tb_transaksi, $periode, $tahun));
        echo $this->trJurnal('Piutang', '', '', 4, $this->summarySAPiutang($tb_transaksi, $periode, $tahun));
        echo $this->trJurnal('Penerimaan Pembayaran Siswa belum disetor', '', '', 4, $this->belumSetor($tb_transaksi_aks));
        echo $this->trJurnal('Aset Lainnya', 'text-secondary', 'b', 3, $this->summaryAsetLainnya($tb_siswa, $tb_transaksi_aks, $tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Tanggungan Siswa belum dibayar', '', '', 4, $this->tanggunganbelumDibayar($tb_siswa,  $tb_transaksi_aks));
        echo $this->trJurnal('Aset Lainnya', '', '', 4, $this->sumNeraca($tb_jurnal, '11',  $periode, $tahun));
        //Kewajiban
        echo $this->trJurnal('Kewajiban', 'text-primary', 'b', 0, $this->summaryKewajiban($tb_transaksi, $tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Kewajiban kepada pihak ketiga', 'text-secondary', 'b', 3, $this->summaryKewajibanPihakLain($tb_transaksi, $tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Hutang', '', '', 4, $this->summarySAHutang($tb_transaksi, $periode, $tahun));
        echo $this->trJurnal('Pungutan Pajak belum dibayar', '', '', 4, $this->summarySAPajak($tb_transaksi, $periode, $tahun));
        echo $this->trJurnal('Kewajiban Lainnya', 'text-secondary', 'b', 3, $this->summaryKewajibanLainnya($tb_jurnal, $periode, $tahun));
        echo $this->trJurnal('Kewajiban Lainnya', '', '', 4, $this->sumNeraca($tb_jurnal, '14',  $periode, $tahun));

        //Ekuitas
        echo $this->trJurnal('Ekuitas', 'text-primary', 'b', 0, $this->summaryEkuitas($tb_siswa, $tb_transaksi,  $tb_transaksi_aks, $tb_jurnal, $periode, $tahun));
    }
}
