<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class format
{
    public function ribuan($nominal)
    {
        if ($nominal == 0 || $nominal == "") {
            $value = 0;
        } elseif ($nominal < 1000 && $nominal > 0) {
            $value = $nominal;
        } else {
            $value = number_format($nominal, 0, ",", ".");
        };
        return $value;
    }
    public function persen($nom1, $nom2)
    {
        if ($nom1 == 0 || $nom2 == 0 || $nom1 == "" || $nom2 == "") {
            $value = 0;
        } else {
            //$value = number_format(($nom1 / $nom2) * 100, 2);
            $value = number_format((($nom1 != 0) ? ($nom1 / $nom2) * 100 : 0), 2);
        };
        return $value;
    }

    public function terbilang($x)
    {
        $abil = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");

        $x = (int)$x;
        if ($x < 12) {
            $value = $abil[$x];
        } elseif ($x < 20) {
            $value = self::terbilang(($x - 10)) . " belas ";
        } elseif ($x < 100) {
            $value =  self::terbilang(($x / 10)) . " puluh " . self::terbilang($x % 10);
        } elseif ($x < 200) {
            $value =  " seratus " . self::terbilang($x - 100);
        } elseif ($x < 1000) {
            $value =  self::terbilang(($x / 100)) . " ratus " . self::terbilang($x % 100);
        } elseif ($x < 2000) {
            $value =  " seribu " . self::terbilang($x - 1000);
        } elseif ($x < 1000000) {
            $value =  self::terbilang(($x / 1000)) . " ribu " . self::terbilang($x % 1000);
        } elseif ($x < 1000000000) {
            $value = self::terbilang(($x / 1000000)) . " juta " . self::terbilang($x % 1000000);
        }
        return $value;
    }
    public function dateToIndo($date)
    {
        $BulanIndo = array(
            "01", "02", "03",
            "04", "05", "06",
            "07", "08", "09",
            "10", "11", "12"
        );

        $tahun = substr($date, 0, 4);
        $bulan = substr($date, 5, 2);
        $tgl   = substr($date, 8, 2);

        $result = $tgl . "-" . $BulanIndo[(int)$bulan - 1] . "-" . $tahun;
        return ($result);
    }
    public function dateTimeToIndo($dateTime)
    {
        $BulanIndo = array(
            "01", "02", "03",
            "04", "05", "06",
            "07", "08", "09",
            "10", "11", "12"
        );

        //2023-09-17 05:52:34

        $tahun = substr($dateTime, 0, 4);
        $bulan = substr($dateTime, 5, 2);
        $tgl   = substr($dateTime, 8, 2);
        $time = substr($dateTime, 11, 8);

        $result = $tgl . "-" . $BulanIndo[(int)$bulan - 1] . "-" . $tahun . " " . $time;
        // $result = $tgl . "-" . $bulan . "-" . $tahun . " " . $time;
        return ($result);
    }

    public function dateToIndoLong($date)
    {
        $BulanIndo = array(
            "Januari", "Februari", "Maret",
            "April", "Mei", "Juni",
            "Juli", "Agustus", "September",
            "Oktober", "November", "Desember"
        );

        $tahun = substr($date, 0, 4);
        $bulan = substr($date, 5, 2);
        $tgl   = substr($date, 8, 2);

        $result = $tgl . " " . $BulanIndo[(int)$bulan - 1] . " " . $tahun;
        return ($result);
    }

    public function dateToEng($date)
    {
        $BulanEng = array(
            "01", "02", "03",
            "04", "05", "06",
            "07", "08", "09",
            "10", "11", "12"
        );

        $tahun = substr($date, 6, 4);
        $bulan = substr($date, 3, 2);
        $tgl   = substr($date, 0, 2);

        $result = $tahun . "-" . $BulanEng[(int)$bulan - 1] . "-" . $tgl;
        return ($result);
    }

    public function hari($tanggal)
    {
        $day = date('D', strtotime($tanggal));
        $dayList = array(
            'Sun' => 'Minggu',
            'Mon' => 'Senin',
            'Tue' => 'Selasa',
            'Wed' => 'Rabu',
            'Thu' => 'Kamis',
            'Fri' => 'Jumat',
            'Sat' => 'Sabtu'
        );
        $value = $dayList[$day];
        return $value;
    }

    public function tahunLalu($tahun)
    {
        $tahun1 = ((int)substr($tahun, 0, 4)) - 1;
        $tahun2 = ((int)substr($tahun, 5, 4)) - 1;
        $value = $tahun1 . "/" . $tahun2;
        return $value;
    }
    public function entityEncode($text)
    {
        $value = html_entity_decode($text);
        return $value;
    }

    public function onlyNumber()
    {
        $value = "oninput=this.value=this.value.replace(/[aA-zZ.]/g,'').replace(/(\..*)./g,'$1')";
        return $value;
    }
    public function numberFormat($angka, $digit)
    {
        $value = number_format($angka, $digit, ",", ".");
        return $value;
    }
}
