<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class backup extends config
{

    public function backup_proses($tahun, $metode)
    {
        $clsTime = new time;
        $today = $clsTime->getDateBackup();
        $periode = substr($clsTime->getDateBackup(), 2, 2);
        $tp_back = substr($tahun, 0, 4) . '_' . substr($tahun, 5, 4);

        $tables = $this->tables($tahun);
        $db = database::getInstance();

        if ($metode == "M") {
            $backup = $this->backup_exec($db, $tables, $tahun, $today . '_M');
            $this->zipBackup("AKSSIMAKOM6_" . $tp_back . "_" . $today . "_M", '../../asset/backup/');
            $direct = new toast();
            echo $direct->redirect('toast', 'backup', 'utility/backup/index');
        } elseif ($metode == "D") {
            $backup = $this->backup_exec($db, $tables, $tahun, 'D');
            $this->zipBackup("AKSSIMAKOM6_" . $tp_back . "_D", '../../asset/backup/');
            $direct = new toast();
            echo $direct->redirect('toast', 'backup', 'beranda');
        } elseif ($metode == "A") {
            $backup = $this->backup_exec($db, $tables, $tahun, $periode . '_A');
            $this->zipBackup("AKSSIMAKOM6_" . $tp_back . "_" . $periode . "_A", '../../asset/backup/');
        }


        return true;
    }

    private function tables($tahun)
    {

        $clsTabel = new cekTabel;
        $tb_komponen = $clsTabel->getTabel('simakom_komponen', $tahun);
        $tb_kegiatan = $clsTabel->getTabel('simakom_kegiatan', $tahun);
        $tb_akun = $clsTabel->getTabel('simakom_akun', $tahun);
        $tb_detail = $clsTabel->getTabel('simakom_detail', $tahun);
        $tb_jurnal = $clsTabel->getTabel('simakom_jurnal', $tahun);
        $tb_revisi = $clsTabel->getTabel('simakom_revisi', $tahun);
        $tb_transaksi_simakom = $clsTabel->getTabel('simakom_transaksi', $tahun);
        $tb_lpj_simakom = $clsTabel->getTabel('simakom_lpj', $tahun);
        $tb_siswa_aks = $clsTabel->getTabel('tb_siswa', $tahun);
        $tb_siswa_min = $clsTabel->getTabel('tb_siswa_min', $tahun);
        $tb_transaksi_aks = $clsTabel->getTabel('db_transaksi', $tahun);
        $tb_setor = $clsTabel->getTabel('db_setor', $tahun);
        $tb_tabungan_siswa = $clsTabel->getTabel('tabungan_siswa', $tahun);
        $tb_tabungan_transaksi = $clsTabel->getTabel('tabungan_transaksi', $tahun);
        $payment_list = $clsTabel->getTabel('payment_list', $tahun);

        $tables = "sekolah,serial,user,user_siswa,simakom_ref_akun,simakom_ref_kegiatan,tb_nama_bayar,tb_paralel,tb_siswa_kategori,tb_tp,tb_walikelas,whatsapp,tabungan_periode,$tb_komponen,$tb_kegiatan,$tb_akun,$tb_detail,$tb_jurnal,$tb_revisi,$tb_transaksi_simakom,$tb_lpj_simakom,$tb_setor,$tb_siswa_min,$tb_siswa_aks,$payment_list,payment_set,$tb_tabungan_siswa,$tb_transaksi_aks,$tb_tabungan_transaksi";

        return $tables;
    }

    private function backup_exec($DBH, $tables, $tahun, $metode)
    {

        $_host = $this->_host;
        $_dbname = $this->_dbname;
        $_username = $this->_username;
        $_password = $this->_password;

        $pdo = new PDO('mysql:host=' . $_host . ';dbname=' . $_dbname, $_username, $_password, array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ));

        $DBH = new PDO("mysql:host=$_host;dbname=$_dbname; charset=utf8", $_username, $_password);

        $DBH->setAttribute(PDO::ATTR_ORACLE_NULLS, PDO::NULL_NATURAL);

        $tp_back = substr($tahun, 0, 4) . '_' . substr($tahun, 5, 4);

        $compression = false;
        //$BACKUP_PATH = "../../asset/backup/";
        $BACKUP_PATH = "./";
        $nowtimename = "AKSSIMAKOM6_" . $tp_back . "_" . $metode;

        $servroot = $_SERVER['DOCUMENT_ROOT'];
        $servweb = $_SERVER['HTTP_HOST'];

        if (file_exists($servroot . "/asset/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".sql")) {
            unlink($servroot . "/asset/backup/AKSSIMAKOM6_" . $tp_back . "_"  . $metode . ".sql");
        } else {
            echo "";
        };

        //create/open files
        if ($compression) {
            $zp = gzopen($BACKUP_PATH . $nowtimename . '.sql.gz', "a9");
        } else {
            $handle = fopen($BACKUP_PATH . $nowtimename . '.sql', 'a+');
        }

        //array of all database field types which just take numbers 
        $numtypes = array('tinyint', 'smallint', 'mediumint', 'int', 'bigint', 'float', 'double', 'decimal', 'real');

        //get all of the tables
        if (empty($tables)) {
            $pstm1 = $DBH->query('SHOW TABLES');
            while ($row = $pstm1->fetch(PDO::FETCH_NUM)) {
                $tables[] = $row[0];
            }
        } else {
            $tables = is_array($tables) ? $tables : explode(',', $tables);
        }

        //cycle through the table(s)

        foreach ($tables as $table) {
            $result = $DBH->query("SELECT * FROM $table");
            $num_fields = $result->columnCount();
            $num_rows = $result->rowCount();

            $return = "";
            //uncomment below if you want 'DROP TABLE IF EXISTS' displayed
            $return .= 'DROP TABLE IF EXISTS `' . $table . '`;';

            //table structure
            $pstm2 = $DBH->query("SHOW CREATE TABLE $table");
            $row2 = $pstm2->fetch(PDO::FETCH_NUM);

            // Add DROP TABLE statement

            $ifnotexists = str_replace('CREATE TABLE', 'CREATE TABLE IF NOT EXISTS', $row2[1]);
            $return .= "\n\n" . $ifnotexists . ";\n\n";


            if ($compression) {
                gzwrite($zp, $return);
            } else {
                fwrite($handle, $return);
            }
            $return = "";

            //insert values
            if ($num_rows) {
                $return = 'INSERT INTO `' . "$table" . "` (";
                $pstm3 = $DBH->query("SHOW COLUMNS FROM $table");
                $count = 0;
                $type = array();

                while ($rows = $pstm3->fetch(PDO::FETCH_NUM)) {

                    if (stripos($rows[1], '(')) {
                        $type[$table][] = stristr($rows[1], '(', true);
                    } else $type[$table][] = $rows[1];

                    $return .= "`" . $rows[0] . "`";
                    $count++;
                    if ($count < ($pstm3->rowCount())) {
                        $return .= ", ";
                    }
                }

                $return .= ")" . ' VALUES';

                if ($compression) {
                    gzwrite($zp, $return);
                } else {
                    fwrite($handle, $return);
                }
                $return = "";
            }
            $count = 0;
            while ($row = $result->fetch(PDO::FETCH_NUM)) {
                $return = "\n\t(";

                for ($j = 0; $j < $num_fields; $j++) {


                    if (isset($row[$j])) {

                        //if number, take away "". else leave as string
                        if ((in_array($type[$table][$j], $numtypes)) && (!empty($row[$j]))) $return .= $row[$j];
                        else $return .= $DBH->quote($row[$j]);
                    } else {
                        $return .= 'NULL';
                    }
                    if ($j < ($num_fields - 1)) {
                        $return .= ',';
                    }
                }
                $count++;
                if ($count < ($result->rowCount())) {
                    $return .= "),";
                } else {
                    $return .= ");";
                }
                if ($compression) {
                    gzwrite($zp, $return);
                } else {
                    fwrite($handle, $return);
                }
                $return = "";
            }
            $return = "\n\n-- ------------------------------------------------ \n\n";
            if ($compression) {
                gzwrite($zp, $return);
            } else {
                fwrite($handle, $return);
            }
            $return = "";
        }

        $error1 = $pstm2->errorInfo();
        $error2 = $pstm3->errorInfo();
        $error3 = $result->errorInfo();
        echo $error1[2];
        echo $error2[2];
        echo $error3[2];

        if ($compression) {
            gzclose($zp);
        } else {
            fclose($handle);
        }

        //zip backup

        // $this->zipBackup($nowtimename . ".sql");
        //ekstrak
        $simner = new simakom_neraca;
        $ekstrak = $simner->cpy_ekstrak('../../app.zip');
        $ekstrak = $simner->cpy_ekstrak('../../asset/mod.zip');
        $update = new update;
        $update = $update->downUp();
    }

    public function restore()
    {

        // $db = database::getInstance();
        $_host = $this->_host;
        $_dbname = $this->_dbname;
        $_username = $this->_username;
        $_password = $this->_password;

        $pdo = new PDO('mysql:host=' . $_host . ';dbname=' . $_dbname, $_username, $_password, array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ));

        if (isset($_POST['restore'])) {

            $nama_file = $_FILES['datafile']['name'];
            // $ukuran = $_FILES['datafile']['size'];

            //periksa jika data yang dimasukan belum lengkap
            if ($nama_file == "") {
                echo "File belum ditentukan";
                echo "<script>confirm('File Backup tidak ditemukan !')</script>";
            } else {
                //definisikan variabel file dan alamat file
                $uploaddir = '../../asset/backup/restore/';
                //$uploaddir = '../backup/';
                $alamatfile = $uploaddir . $nama_file;

                if (move_uploaded_file($_FILES['datafile']['tmp_name'], $alamatfile)) {
                    /**
                     * Import SQL File
                     *
                     * @param $pdo
                     * @param $sqlFile
                     * @param null $tablePrefix
                     * @param null $InFilePath
                     * @return bool
                     */
                    $filePath = '../../asset/backup/restore/' . $nama_file;
                    //$filePath = '../backup/' . $nama_file;
                    // Import the SQL file
                    $res = $this->restore_exec($pdo, $filePath);
                    if ($res === false) {
                        die('ERROR');
                    }
                } else {
                    //jika gagal
                    echo "Proses upload gagal, kode error = " . $_FILES['location']['error'];
                    echo "";
                }
                $direct = new toast();
                echo $direct->redirect('toast', 'restore', 'utility/backup/index');
            }
        } else {
            unset($_POST['restore']);
        };
    }

    public function reset_db()
    {

        // $db = database::getInstance();
        $_host = $this->_host;
        $_dbname = $this->_dbname;
        $_username = $this->_username;
        $_password = $this->_password;

        $pdo = new PDO('mysql:host=' . $_host . ';dbname=' . $_dbname, $_username, $_password, array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ));

        if (isset($_POST['submitreset'])) {

            $nama_file = "reset.sql";
            // $ukuran = $_FILES['datafile']['size'];

            //periksa jika data yang dimasukan belum lengkap
            if ($nama_file == "") {
                // echo "File belum ditentukan";
                echo "<script>confirm('File Reset tidak ditemukan !')</script>";
            } else {
                //definisikan variabel file dan alamat file
                $uploaddir = './asset/backup/restore/';
                //$uploaddir = '../backup/';
                $alamatfile = $uploaddir . $nama_file;

                //if (move_uploaded_file($_FILES['datafile']['tmp_name'], $alamatfile)) {
                /**
                 * Import SQL File
                 *
                 * @param $pdo
                 * @param $sqlFile
                 * @param null $tablePrefix
                 * @param null $InFilePath
                 * @return bool
                 */
                $filePath = './asset/backup/restore/' . $nama_file;
                //$filePath = '../backup/' . $nama_file;
                // Import the SQL file
                $res = $this->restore_exec($pdo, $filePath);
                if ($res === false) {
                    die('ERROR');
                }
                // } else {
                //jika gagal
                //    echo "Proses upload gagal, kode error = " . $_FILES['location']['error'];
                //     echo "";
                // }
                $direct = new toast();
                echo $direct->redirect('toast', 'reset', './');
            }
        } else {
            unset($_POST['submitreset']);
        };
    }


    private function restore_exec($pdo, $sqlFile, $tablePrefix = null, $InFilePath = null)
    {
        try {

            // Enable LOAD LOCAL INFILE
            $pdo->setAttribute(\PDO::MYSQL_ATTR_LOCAL_INFILE, true);

            $errorDetect = false;

            // Temporary variable, used to store current query
            $tmpLine = '';

            // Read in entire file
            $lines = file($sqlFile);

            // Loop through each line
            foreach ($lines as $line) {
                // Skip it if it's a comment
                if (substr($line, 0, 2) == '--' || trim($line) == '') {
                    continue;
                }

                // Read & replace prefix
                $line = str_replace(['<<prefix>>', '<<InFilePath>>'], [$tablePrefix, $InFilePath], $line);

                // Add this line to the current segment
                $tmpLine .= $line;

                // If it has a semicolon at the end, it's the end of the query
                if (substr(trim($line), -1, 1) == ';') {
                    try {
                        // Perform the Query
                        $pdo->exec($tmpLine);
                    } catch (\PDOException $e) {
                        echo "<br><pre>Error performing Query: '<strong>" . $tmpLine . "</strong>': " . $e->getMessage() . "</pre>\n";
                        $errorDetect = true;
                    }

                    // Reset temp variable to empty
                    $tmpLine = '';
                }
            }

            // Check if error is detected
            if ($errorDetect) {
                return false;
            }
        } catch (\Exception $e) {
            echo "<br><pre>Exception => " . $e->getMessage() . "</pre>\n";
            return false;
        }

        return true;
    }

    public function fileBackupAuto($tahun, $periode)
    {
        $servroot = $_SERVER['DOCUMENT_ROOT'];
        //$servweb = $_SERVER['HTTP_HOST'];
        //$domain = $_SERVER['REQUEST_URI'];
        $tp_back = substr($tahun, 0, 4) . '_' . substr($tahun, 5, 4);
        $metode = $periode . "_A";

        if (file_exists($servroot . "/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".zip") || file_exists("../../asset/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".zip") || file_exists("../../../../../asset/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".zip")) {
            $fileBCK = "../../../../../asset/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".zip";
            $fileTime = date("d/m/Y h:i", filemtime($fileBCK));
            $filebackup = "<a href='../../asset/backup/AKSSIMAKOM6_" . $tp_back . "_" . $metode . ".zip'><button type='button' class='btn btn-warning btn-xs mx-1 mt-1' name='download'><i class='bi-file'></i> FILE BACKUP $periode $tahun : $fileTime</button></a>";
        } else {
            $fileBCK = "";
            $fileTime = "";
            $filebackup = "";
        };

        return $filebackup;
    }
    public function countRecord($tahun)
    {
        $clsCrud = new crudData;
        $cekTabel = new cekTabel;

        $listDB = "<table class='table table-bordered table-condensed table-sm'>
        <tr color='#FFC4DD' height='30'>
            <td color='#FFC4DD'><b class='text-danger'>Tabel</b></td>
            <td><b class='text-danger'>Modul</b></td>
            <td><b class='text-danger'>Record [Data]</b></td>
        </tr>
        <tr>
            <td>Tabel Siswa</td>
            <td>AKS</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('tb_siswa', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Transaksi AKS</td>
            <td>AKS</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('db_transaksi', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Setor</td>
            <td>AKS/SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('db_setor', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Komponen RKAS</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_komponen', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Kegiatan RKAS</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_kegiatan', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Akun RKAS</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_akun', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Detail RKAS</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_detail', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Revisi RKAS</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_revisi', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Transaksi</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_transaksi', $tahun), '') . "</td>
        </tr>
        <tr>
            <td>Tabel Kuitansi</td>
            <td>SIMAKOM</td>
            <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('simakom_transaksi', $tahun), '') . "</td>
        </tr>
        <tr>
        <td>Tabel Nasabah</td>
        <td>TABUNGAN</td>
        <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('tabungan_siswa', $tahun), '') . "</td>
    </tr>
    <tr>
    <td>Tabel Transaksi Tabungan</td>
    <td>TABUNGAN</td>
    <td align='center'>" . $clsCrud->countData($cekTabel->getTabel('tabungan_transaksi', $tahun), '') . "</td>
</tr>
        
        </table>";
        return $listDB;
    }
    public function maxTP()
    {
        $db = database::getInstance();
        $sql = $db->runQuery("SELECT max(tp) as maksimal FROM tb_tp");
        $max = $sql->fetch();
        $value = $max['maksimal'];
        return $value;
    }
    public function zipBackup($filename, $folder)
    {

        $zip = new ZipArchive();
        // $fileZIP = "../../asset/backup/" . $filename . ".zip";
        $fileZIP = "../../asset/backup/" . $filename . ".zip";

        if ($zip->open($fileZIP, ZipArchive::CREATE) !== TRUE) {
            // exit("cannot open <$filename>\n");
            exit("");
        }
        // $zip->addFile($folder . "/" . $filename . ".sql");
        // $zip->addFile($folder . $filename . ".sql");
        $zip->addFile($filename . ".sql");

        $zip->close();

        unlink($filename . ".sql");
    }
}
