<?php

spl_autoload_register(function ($mod) {
    require('../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';
//require '../../../../bootstrap/asset/mod/sekolah.php';

//$tahun = $_GET['tahun'];
//$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);
//$tb_transaksi = "db_transaksi" . $tahun_tabel;

$tb_transaksi =  $_GET['tahun'];

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_col = [
    'font' => ['bold' => true],
    'font-family' => ['Arial'],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN]
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'font' => ['bold' => FALSE],
    'font-family' => ['Arial'],
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];


// Buat header tabel nya pada baris ke 3
$sheet->setCellValue('A1', 'NO');
$sheet->setCellValue('B1', 'TANGGAL');
$sheet->setCellValue('C1', 'NO BUKTI');
$sheet->setCellValue('D1', 'NO BUKTI SISTEM');
$sheet->setCellValue('E1', 'JENIS');
$sheet->setCellValue('F1', 'KATEGORI');
$sheet->setCellValue('G1', 'RKAS_KATEGORI');
$sheet->setCellValue('H1', 'RKAS_KEGIATAN');
$sheet->setCellValue('I1', 'RKAS_KOMPONEN');
$sheet->setCellValue('J1', 'RKAS_AKUN');
$sheet->setCellValue('K1', 'RKAS_DETAIL');
$sheet->setCellValue('L1', 'URAIAN');
$sheet->setCellValue('M1', 'DEBET');
$sheet->setCellValue('N1', 'KREDIT');
$sheet->setCellValue('O1', 'PENERIMA');
$sheet->setCellValue('P1', 'JABATAN PENERIMA ');
$sheet->setCellValue('Q1', 'PEMBIAAAN_ID');
$sheet->setCellValue('R1', 'PEMBIAAAN_KEGIATAN');
$sheet->setCellValue('S1', 'PEMBIAYAAN_KOMPONEN');
$sheet->setCellValue('T1', 'PEMBIAYAAN_AKUN');
$sheet->setCellValue('U1', 'PAJAK');
$sheet->setCellValue('V1', 'AKUN PAJAK');
$sheet->setCellValue('W1', 'REVISI');
$sheet->setCellValue('X1', 'ID_SETOR');
$sheet->setCellValue('Y1', 'WAKTU');
$sheet->setCellValue('Z1', 'ID');
// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet->getStyle('A1:z1')->applyFromArray($style_col);
$spreadsheet->getActiveSheet()->getStyle('A1:z1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');


// Buat query untuk menampilkan semua data siswa
$crud = new crudData();
$sql = $crud->showTable($tb_transaksi);

$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
while ($data = $sql->fetch(PDO::FETCH_OBJ)) {
    $sheet->setCellValue('A' . $row, $no);
    $sheet->setCellValue('B' . $row, $data->tanggal);
    $sheet->setCellValue('C' . $row, $data->bukti);
    $sheet->setCellValue('D' . $row, $data->bukti_sistem);
    $sheet->setCellValue('E' . $row, $data->jenis);
    $sheet->setCellValue('F' . $row, $data->kategori);
    $sheet->setCellValue('G' . $row, $data->rkas_kategori);
    $sheet->setCellValue('H' . $row, $data->rkas_kegiatan);
    $sheet->setCellValue('I' . $row, $data->rkas_komponen);
    $sheet->setCellValue('J' . $row, $data->rkas_akun);
    $sheet->setCellValue('K' . $row, $data->rkas_detail_id);
    $sheet->setCellValue('L' . $row, $data->uraian);
    $sheet->setCellValue('M' . $row, $data->debet);
    $sheet->setCellValue('N' . $row, $data->kredit);
    $sheet->setCellValue('O' . $row, $data->penerima);
    $sheet->setCellValue('P' . $row, $data->penerima_jabatan);
    $sheet->setCellValue('Q' . $row, $data->pembiayaan_id);
    $sheet->setCellValue('R' . $row, $data->pembiayaan_kegiatan);
    $sheet->setCellValue('S' . $row, $data->pembiayaan_komponen);
    $sheet->setCellValue('T' . $row, $data->pembiayaan_akun);
    $sheet->setCellValue('U' . $row, $data->pajak);
    $sheet->setCellValue('V' . $row, $data->pajak_akun);
    $sheet->setCellValue('W' . $row, $data->revisi);
    $sheet->setCellValue('X' . $row, $data->id_setor);
    $sheet->setCellValue('Y' . $row, $data->time);
    $sheet->setCellValue('Z' . $row, $data->id);



    // Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
    $sheet->getStyle('A' . $row . ':Z' . $row)->applyFromArray($style_row);
    $sheet->getStyle('A' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('B' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet->getStyle('C' . $row . ':K' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('L' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet->getStyle('M' . $row . ':N' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet->getStyle('O' . $row . ':Z' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

    //$sheet->getStyle('J' . $row . ':J' . $row)
    //    ->getNumberFormat()
    //    ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
    //

    $no++; // Tambah 1 setiap kali looping
    $row++; // Tambah 1 setiap kali looping

    //$sheet->getStyle('A1:U' . $row)->getFont()->setName('Arial');
}

// Set width kolom
$sheet->getColumnDimension('A')->setWidth(5);
$sheet->getColumnDimension('B')->setWidth(15);
$sheet->getColumnDimension('C')->setWidth(15);
$sheet->getColumnDimension('D')->setWidth(60);
$sheet->getColumnDimension('E')->setWidth(10);
$sheet->getColumnDimension('F')->setWidth(10);
$sheet->getColumnDimension('G')->setWidth(20);
$sheet->getColumnDimension('H')->setWidth(10);
$sheet->getColumnDimension('I')->setWidth(10);
$sheet->getColumnDimension('J')->setWidth(15);
$sheet->getColumnDimension('K')->setWidth(35);
$sheet->getColumnDimension('L')->setWidth(50);
$sheet->getColumnDimension('M')->setWidth(10);
$sheet->getColumnDimension('N')->setWidth(15);
$sheet->getColumnDimension('O')->setWidth(15);
$sheet->getColumnDimension('P')->setWidth(25);
$sheet->getColumnDimension('Q')->setWidth(25);
$sheet->getColumnDimension('R')->setWidth(30);
$sheet->getColumnDimension('S')->setWidth(70);
$sheet->getColumnDimension('R')->setWidth(30);
$sheet->getColumnDimension('U')->setWidth(30);
$sheet->getColumnDimension('V')->setWidth(30);
$sheet->getColumnDimension('w')->setWidth(30);
$sheet->getColumnDimension('x')->setWidth(30);
$sheet->getColumnDimension('y')->setWidth(30);
$sheet->getColumnDimension('z')->setWidth(30);



// Set orientasi kertas jadi LANDSCAPE
$sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);

// Set judul file excel nya
$sheet->setTitle("Data Transaksi");

// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Daftar Transaksi.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
