<?php

spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

$sekolah = new sekolah;
$format = new format;
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);
$tahunnow = date("Y", $tanggal);

if (isset($_GET['tahun'])) {
    $tahun = $_GET['tahun'];
} else {
    $tahun = $tahunnow;
};

if (isset($_GET['tgl_1'])) {
    $tgl1 = $_GET['tgl_1'];
} else {
    $tgl1 = $tglsekarang;
};
if (isset($_GET['tgl_2'])) {
    $tgl2 = $_GET['tgl_2'];
} else {
    $tgl2 = $tglsekarang;
};
if (isset($_GET['penerima_lap']) && $_GET['penerima_lap'] != 'Semua') {
    $penerima_lap = $_GET['penerima_lap'];
    $penerima_filter = "and penerima='$_GET[penerima_lap]'";
} else {
    $penerima_lap = "Semua";
    $penerima_filter = "";
};
if (isset($_GET['jenjang_lap']) && $_GET['jenjang_lap'] != 'Semua') {
    $jenjang_lap = $_GET['jenjang_lap'];
    $jenjang_filter = "and jenjang='$_GET[jenjang_lap]'";
} else {
    $jenjang_lap = "Semua";
    $jenjang_filter = "";
};
if (isset($_GET['paralel_lap']) && $_GET['paralel_lap'] != 'Semua') {
    $paralel_lap = $_GET['paralel_lap'];
    $paralel_filter = "and paralel='$_GET[paralel_lap]'";
} else {
    $paralel_lap = "Semua";
    $paralel_filter = "";
};
if (isset($_GET['kategori']) && $_GET['kategori'] != 'Semua') {
    $kategori_lap = $_GET['kategori'];
    $kategori_filter = "and kategori='$_GET[kategori]'";
} else {
    $kategori_lap = "Semua";
    $kategori_filter = "";
};
if (isset($_GET['metode_lap']) && $_GET['metode_lap'] != 'Semua') {
    $metode_lap = $_GET['metode_lap'];
    $metode_filter = "and metode='$_GET[metode_lap]'";
} else {
    $metode_lap = "Semua";
    $metode_filter = "";
};

$tahun1 = substr($tahun, 0, 4);
$tahun2 = substr($tahun, 5, 4);

$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_transaksi = "db_transaksi" . $tahun_tabel;
$tb_detailakun = "detail_akun" . $tahun_tabel;
$tgl_1 = $format->dateToEng($tgl1);
$tgl_2 = $format->dateToEng($tgl2);

header("Content-type: application/vnd-ms-excel");
header("Content-Disposition: attachment; filename=Laporan Rekap Per Jenis Pembayaran.xls");


?>

<style>
    .fontdata {
        font-size: 12px;
        font-family: arial;
    }

    .fontJudul {
        font-size: 14px;
        font-family: arial;

    }
</style>



<h4 class="box-title fontJudul">Laporan Realisasi Pendapatan dan Belanja<br><?php echo $sekolah->dataSekolah('sekolah'); ?><br>Tahun Pelajaran <?php echo $tahun; ?></5>



    <table border="1" width="900" cellpadding="2" cellspacing="0" class="table table-bordered table-sm fontdata">
        <thead>
            <tr height="30">
            <tr>
                <th>#</th>
                <th>Kode : Jenis Pembayaran</th>
                <th>Record</th>
                <th>Jumlah</th>

            </tr>
            </tr>
        </thead>
        <tbody>
            <?php
            $classForm = new form();
            $format = new format();
            $crud = new crudData();
            $jenis = $classForm->optSelect('tb_nama_bayar', " group by kode order by kode asc");
            while ($datajenis = $jenis->fetch(PDO::FETCH_OBJ)) {
                $kodejenis = $datajenis->kode;
                echo "
                        <tr>
                            <td width='5px'>#</td>
                            <td align=left><b>Kode $kodejenis </b></td>
                            <td align=right><b>" . $format->ribuan($crud->countData($tb_transaksi, "where tanggal>='$tgl_1' and tanggal<='$tgl_2'  and jenis='$kodejenis' $penerima_filter $metode_filter $kategori_filter ")) . " Data</b></td>
                            <td align=right><b>" . $format->ribuan($crud->sum($tb_transaksi, 'jumlah', "where tanggal>='$tgl_1' and tanggal<='$tgl_2' and jenis='$kodejenis' $penerima_filter $metode_filter $kategori_filter")) . "</b></td>
                        </tr>";
                $classLaporan = new laporan();
                $tingkat = $classForm->optSelect('tb_nama_bayar', " where tp='$tahun' and kode='$kodejenis'  group by kelas order by kelas asc");

                while ($datatingkat = $tingkat->fetch(PDO::FETCH_OBJ)) {

                    $namaBayar = $datatingkat->nama;

                    echo "
                            <tr>
                                <td width='5px'></td>
                                <td align=left>Kelas $datatingkat->kelas : $kodejenis : $namaBayar</td>
                                <td align=right><i>" .   $format->ribuan($crud->countData($tb_transaksi, "where tanggal>='$tgl_1' and tanggal<='$tgl_2' and jenjang='$datatingkat->kelas' and jenis='$kodejenis' $penerima_filter $metode_filter $kategori_filter")) . " Data</i></td>
                                <td align=right><i>" .  $format->ribuan($crud->sum($tb_transaksi, 'jumlah', "where tanggal>='$tgl_1' and tanggal<='$tgl_2' and jenjang='$datatingkat->kelas' and jenis='$kodejenis' $penerima_filter $metode_filter $kategori_filter")) . "</i></td>
                            </tr>";
                };
            };
            echo "
                            <tr>
                                <td width='5px'></td>
                                <td align=left ><b>TOTAL </b></td>
                                <td align=right><b>" .  $classLaporan->CountRecordAll($tb_transaksi, $tgl_1, $tgl_2, $penerima_lap, $metode_lap,  $kategori_lap) . " Data</b></td>
                                <td align=right><b>" . $format->ribuan($classLaporan->TransaksiTotal($tb_transaksi, $tgl_1, $tgl_2, $penerima_lap, $metode_lap,  $kategori_lap)) . "</b></td>
                            </tr>";

            ?>
        </tbody>
    </table>