<?php

spl_autoload_register(function ($mod) {
    require('../../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';
$classsekolah = new sekolah();
$cekID = new cekID();
$crud = new crudData();
$format = new format();
$classRKAS = new simakom_rkas();

$sekolah = $classsekolah->dataSekolah('sekolah');


$tahun = $_GET['tahun'];
$id = $_GET['i4'];

$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);
$tb_komponen = "simakom_komponen" . $tahun_tabel;
$tb_kegiatan = "simakom_kegiatan" . $tahun_tabel;
$tb_akun = "simakom_akun" . $tahun_tabel;
$tb_detail = "simakom_detail" . $tahun_tabel;
$tb_revisi = "simakom_revisi" . $tahun_tabel;
$tb_transaksi = "simakom_transaksi" . $tahun_tabel;
$tb_jurnal = "simakom_jurnal" . $tahun_tabel;

$sql = $crud->editData($tb_komponen, 'id', $id);
$data = $sql->fetch(PDO::FETCH_OBJ);

$uraian_kategori = $classRKAS->uraianRKAS('simakom_ref_kategori', 'kategori', $data->kategori, 'uraian');
$uraian_kegiatan = $classRKAS->uraianRKAS($tb_kegiatan, 'kegiatan', $data->kegiatan, 'uraian');
$uraian_komponen = $classRKAS->uraianRKAS($tb_komponen, 'kode_id', $data->kategori . $data->kegiatan . $data->komponen, 'uraian');
//$uraian_akun = $classRKAS->kodeCustome('simakom_ref_akun', 'akun', $data->akun, 'uraian');
//$uraian_detail = $classRKAS->kodeCustome($tb_detail, 'id', $data->id, 'uraian');

if ($data->kategori == 'A') {
    $debkredi = 'debet';
} else {
    $debkredi = 'kredit';
};
$jumlah = $crud->sum($tb_transaksi, $debkredi, "where rkas_kategori='$data->kategori' && rkas_kegiatan='$data->kegiatan' && rkas_komponen='$data->komponen' ");

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet1 = $spreadsheet->setActiveSheetIndex(0);

$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);
$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$spreadsheet->getActiveSheet()->getPageMargins()->setTop(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(1);
// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_judul = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],

];
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];


$sheet1->getStyle('A1')->getFont()->setBold(true);
$sheet1->getStyle('A1')->getFont()->setSize(15);
$sheet1->getStyle('A1:G1000')->getFont()->setName('Arial');


$sheet1->getColumnDimension('A')->setWidth(5);
$sheet1->getColumnDimension('B')->setWidth(14);
$sheet1->getColumnDimension('C')->setWidth(12);
$sheet1->getColumnDimension('D')->setWidth(60);
$sheet1->getColumnDimension('E')->setWidth(15);
$sheet1->getColumnDimension('F')->setWidth(15);
$sheet1->getColumnDimension('G')->setWidth(25);


$sheet1->setCellValue('A1', 'RINCIAN DETAIL TRANSAKSI');
$sheet1->setCellValue('A2', $sekolah);
$sheet1->mergeCells('A1:G1');
$sheet1->mergeCells('A2:G2');

$sheet1->setCellValue('A5', 'KATEGORI');
$sheet1->setCellValue('C5', ': ' . $data->kategori . ' - ' . $uraian_kategori);
$sheet1->setCellValue('A6', 'KEGIATAN');
$sheet1->setCellValue('C6', ': ' . $data->kegiatan . ' - ' . $uraian_kegiatan);
$sheet1->setCellValue('A7', 'KOMPONEN');
$sheet1->setCellValue('C7', ': ' . $data->komponen . ' - ' . $uraian_komponen);



$sheet1->getStyle('A5:C9')->getFont()->setBold(true);

$sheet1->getStyle('A1:G1000')->getFont()->setName('Arial');
$sheet1->getStyle('A7:G1000')->getFont()->setSize(10);

// Buat header tabel nya pada baris ke 3
$sheet1->setCellValue('A9', 'No');
$sheet1->setCellValue('B9', 'No Bukti');
$sheet1->setCellValue('C9', ' Tanggal ');
$sheet1->setCellValue('D9', ' Uraian ');
$sheet1->setCellValue('E9', ' Jumlah ');
$sheet1->setCellValue('F9', ' Akun ');
$sheet1->setCellValue('G9', ' Detail ID ');

// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet1->getStyle('A1:G1')->applyFromArray($style_judul);
$sheet1->getStyle('A2:G2')->applyFromArray($style_judul);

$spreadsheet->getActiveSheet(1)->getStyle('A9:G9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
$sheet1->getStyle('A9:G9')->applyFromArray($style_row);

// Set height baris ke 1, 2 dan 3
$sheet1->getRowDimension('1')->setRowHeight(20);



$simakom_transaksi = new simakom_transaksi;
$db = database::getInstance();
$show = $db->runQuery("SELECT * FROM  $tb_transaksi where rkas_kategori='$data->kategori' && rkas_kegiatan='$data->kegiatan' && rkas_komponen='$data->komponen'  order by tanggal asc,jenis asc, bukti asc, time asc");
$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 10;
while ($data = $show->fetch(PDO::FETCH_OBJ)) {
    $format = new format();
    $tanggal = $format->dateToIndo($data->tanggal);
    $debet = $data->debet;
    $kredit = $data->kredit;
    $akun = $data->rkas_akun;
    $detail_id = $data->rkas_detail_id;
    $jenis_transaksi = $data->jenis;

    $link = new linkpage();

    if ($data->rkas_kategori == "A") {
        $jumlah = $debet;
    } else {
        $jumlah = $kredit;
    };

    $sheet1->setCellValue('A' . $row, $no);
    $sheet1->setCellValue('B' . $row, $data->bukti);
    $sheet1->setCellValue('C' . $row, $tanggal);
    $sheet1->setCellValue('D' . $row, $data->uraian);
    $sheet1->setCellValue('E' . $row, $jumlah);
    $sheet1->setCellValue('F' . $row, $akun);
    $sheet1->setCellValue('G' . $row, $detail_id);
    $no++;
    $row++;
}


$spreadsheet->getActiveSheet()->setTitle('RINCIAN');


// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="RINCIAN DETAIL TRANSAKSI.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
