<?php
function Output($name='',$dest='')
{
	//Output PDF to some destination
	global $HTTP_SERVER_VARS;

//Finish document if necessary
if($this->state<3)
	$this->Close();
//Normalize parameters
if(is_bool($dest))
	$dest=$dest ? 'D' : 'F';
$dest=strtoupper($dest);
if($dest=='')
{
	if($name=='')
	{
		$name='doc.pdf';
		$dest='I';
	}
	else
		$dest='F';
}
switch($dest)
{
	case 'I':
		//Send to standard output
		if(isset($HTTP_SERVER_VARS['SERVER_NAME']))
		{
			//We send to a browser
			Header('Content-Type: application/pdf');
			if(headers_sent())
				$this->Error('Some data has already been output to browser, can\'t send PDF file');
			Header('Content-Length: '.strlen($this->buffer));
			Header('Content-disposition: inline; filename='.$name);
		}
		echo $this->buffer;
		break;
	case 'D':
		//Download file
		if(isset($HTTP_SERVER_VARS['HTTP_USER_AGENT']) and strpos($HTTP_SERVER_VARS['HTTP_USER_AGENT'],'MSIE'))
			Header('Content-Type: application/force-download');
		else
			Header('Content-Type: application/octet-stream');
		if(headers_sent())
			$this->Error('Some data has already been output to browser, can\'t send PDF file');
		Header('Content-Length: '.strlen($this->buffer));
		Header('Content-disposition: attachment; filename='.$name);
		echo $this->buffer;
		break;
	case 'F':
		//Save to local file
		$f=fopen($name,'wb');
		if(!$f)
			$this->Error('Unable to create output file: '.$name);
		fwrite($f,$this->buffer,strlen($this->buffer));
		fclose($f);
		break;
	case 'S':
		//Return as a string
		return $this->buffer;
	default:
		$this->Error('Incorrect output destination: '.$dest);
}
return '';
} 
;?>