<!DOCTYPE html>
<html lang="en">

<head>

    <link rel="stylesheet" href="../../../../../asset/bootstrap/css/adminlte.min.css">

    <style>
        .font {
            font-family: arial;
            font-size: 11px;
        }

        .fontlamp {
            font-family: arial;
            font-size: 8px;
        }

        .fontJudullamp {
            font-size: 12px;
            font-family: arial;

        }

        .fontInput {
            font-size: 11px;
            font-family: arial;
        }

        .fontJudul {
            font-size: 12px;
            font-family: arial;
            color: dodgerblue;
            background: #000;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed small">

    <div class="wrapper">
        <?php
        require('../../../../../asset/mod/autoLoad.php');
        date_default_timezone_set('Asia/Jakarta');
        $tanggal = mktime(date("m"), date("d"), date("Y"));
        $tglsekarang = date("d-m-Y", $tanggal);
        $tahunnow = date("Y", $tanggal);

        if (isset($_GET['tahun'])) {
            $tahun = $_GET['tahun'];
        } else {
            $tahun = $tahunnow;
        };
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        $tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

        $tb_siswa = "tb_siswa" . $tahun_tabel;

        $tabungan_transaksi = "tabungan_transaksi" . $tahun_tabel;
        $tabungan_siswa = "tabungan_siswa" . $tahun_tabel;

        $format = new format;
        $time = new time;
        $clsLaporan = new tabungan_laporan;
        $totalSaldoAWal = $clsLaporan->rekapTotalSaldoAwal($tabungan_siswa, '');
        $totalDebet = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'D', '');
        $totalKredit = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'K', '');
        $totalSaldoAkhir = @((int)$totalSaldoAWal + (int)$totalDebet - (int)$totalKredit);

        ?>

        <div class="container col-12 mb-4">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="card-body col-12 mx-4">
                            <h5 class="page-header">
                                <?php
                                $view = new lembaga;
                                $clssekolah = new sekolah;
                                echo $view->viewImage('../../../../../asset/dokumen/foto/', 'logo', 'mr-2 position-absolute', '60', '60');
                                echo "<b class='d-block ml-5 pl-3 pt-1'>" . $clssekolah->dataSekolah('sekolah') . "</b>";
                                echo "<i class='footer font ml-5 pl-3 mb-2 pb-3'>" . $clssekolah->dataSekolah('alamat')  . "</i>"; ?>
                                <small class="float-right position-relative"><b class="text-danger">LAPORAN REKAPITULASI TABUNGAN<br>TP. <?php echo $tahun; ?></b> </small><br>
                            </h5>

                        </div>
                        <div class="card-body col-12 mx-4">
                            <div class="row invoice-info">
                                <div class="col-sm-12 invoice-col">
                                    <dl class="row">
                                        <dt class="col-sm-4 pt-3">SALDO AWAL</dt>
                                        <dd class="col-sm-8 pt-3"><b>: <?php echo $format->ribuan($totalSaldoAWal); ?></b></dd>
                                        <dt class="col-sm-4">SETORAN</dt>
                                        <dd class="col-sm-8 "><b>: <?php echo $format->ribuan($totalDebet);
                                                                    ?></b></dd>
                                        <dt class="col-sm-4">PENARIKAN</dt>
                                        <dd class="col-sm-8 "><b>: <?php echo $format->ribuan($totalKredit);
                                                                    ?> </b></dd>
                                        <dt class="col-sm-4">SALDO AKHIR</dt>
                                        <dd class="col-sm-8"><b>: <?php echo $format->ribuan($totalSaldoAkhir);
                                                                    ?></b>
                                        </dd>
                                    </dl>
                                </div>
                            </div>

                            <label class="col-3">
                                <span><b class="text-primary">RINCIAN </b> </span>

                            </label>
                            <div class="col-9 float-right">
                                <i class="footnote float-right">Dicetak Pada :<?php echo $format->dateTimeToIndo($time->getTime());
                                                                                ?> </i>

                            </div>
                            <table class="table table-bordered table-striped table-sm">
                                <thead>
                                    <tr>
                                        <th width="15" class="bg-secondary text-light">No</th>
                                        <th class="bg-secondary text-light">NIS</th>
                                        <th class="bg-secondary text-light">Nama Nasabah</th>
                                        <th width="15" class="bg-secondary text-light">L/P</th>
                                        <th class="bg-secondary text-light">Kelas</th>
                                        <th width="100" class="bg-secondary text-light">Saldo Awal</th>
                                        <th width="100" class="bg-secondary text-light">Debet</th>
                                        <th width="100" class="bg-secondary text-light">Kredit</th>
                                        <th width="100" class="bg-secondary text-light">Saldo Akhir</th>
                                        <th class="bg-secondary text-light">Status</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $clsCrud = new crudData();
                                    $show = $clsCrud->showTable($tabungan_siswa . " order by status asc, nama asc");
                                    $no = 0;
                                    while ($data = $show->fetch(PDO::FETCH_OBJ)) {

                                        $nis = $data->nis;
                                        $clsCrud = new crudData;

                                        //count tabel siswa
                                        $count = $clsCrud->countData($tb_siswa, " where nis='$nis'");
                                        if ($count > 0) {
                                            $kelas = $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'jenjang') . "-" . $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'paralel');
                                        } else {
                                            $kelas = "--";
                                        };



                                        $clsTabungan = new tabungan;
                                        $jmlDebet = $clsTabungan->sumByID($tabungan_transaksi, 'D', 'nis', $data->nis);
                                        $jmlKredit = $clsTabungan->sumByID($tabungan_transaksi, 'K', 'nis', $data->nis);

                                        $saldoAkhir = @($data->saldo) + $jmlDebet - $jmlKredit;

                                        $link = new linkpage;
                                        $format = new format;
                                        $no++;
                                        echo "
                                            <tr>
                                                <td align='center'>$no</td>
                                                <td align='center'>$data->nis</td>
                                                <td>$data->nama</td>
                                                <td align='center'>$data->kelamin</td>
                                                <td align='center'>$kelas</td>
                                                <td align='right'>" . $format->ribuan($data->saldo) . "</td>
                                                <td align='right'>" . $format->ribuan($jmlDebet) . "</td>
                                                <td align='right'>" . $format->ribuan($jmlKredit) . "</td>
                                                <td align='right'>" . $format->ribuan($saldoAkhir) . "</td>
                                                <td>$data->status</td>
                                               
                                            </tr>";
                                    };
                                    echo "
                                    <tr>
                                     
                                        <td align=center colspan='5'><b>JUMLAH</b></td>
                                        <td align=right><b>" . $format->ribuan($totalSaldoAWal) . "</b></td>
                                        <td align=right><b>" . $format->ribuan($totalDebet) . "</b></td>
                                        <td align=right><b>" . $format->ribuan($totalKredit) . "</b></td>
                                        <td align=right><b>" . $format->ribuan($totalSaldoAkhir) . "</b></td>
                                        <td align=left ></td>
                                    </tr>";

                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <script src="../../../../../asset/bootstrap/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/sweetalert2/sweetalert2.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/toastr/toastr.min.js"></script>
    <script src="../../../../../asset/bootstrap/js/adminlte.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jquery-ui/jquery-ui.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/chart.js/Chart.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/sparklines/sparkline.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jqvmap/jquery.vmap.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jquery-knob/jquery.knob.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/moment/moment.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/daterangepicker/daterangepicker.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/summernote/summernote-bs4.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
    <script src="../../../../../asset/bootstrap/js/pages/dashboard.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/select2/js/select2.full.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/inputmask/jquery.inputmask.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/bs-stepper/js/bs-stepper.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/dropzone/min/dropzone.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jszip/jszip.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jquery-mousewheel/jquery.mousewheel.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jquery-mapael/jquery.mapael.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/jquery-mapael/maps/usa_states.min.js"></script>
    <script src="../../../../../asset/bootstrap/plugins/raphael/raphael.min.js"></script>
    <script src="../../../../../asset/bootstrap/js/pages/dashboard2.js"></script>

</body>


<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $("#example2").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true,
            "buttons": ["excel", "pdf", "print"]
        }).buttons().container().appendTo('#example2_wrapper .col-md-6:eq(0)');
        $("#example3").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [10, 50, 100, 500, 1000, -1],
                [10, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true
        });
        $("#example14").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": true
        });
        $("#example15").DataTable({
            "responsive": true,
            "lengthChange": true,
            "lengthMenu": [
                [15, 50, 100, 500, 1000, -1],
                [15, 50, 100, 500, 1000, "All"]
            ],
            "autoWidth": true
        });

    });
</script>

</html>