<?php
$format = new format;
$time = new time;
$clsLaporan = new tabungan_laporan;
$totalSaldoAWal = $clsLaporan->rekapTotalSaldoAwal($tabungan_siswa, '');
$totalDebet = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'D', '');
$totalKredit = $clsLaporan->rekapTotalbyJenis($tabungan_transaksi, 'K', '');
$totalSaldoAkhir = @((int)$totalSaldoAWal + (int)$totalDebet - (int)$totalKredit);

//HAPUS SEMUA FILE DALAM FOLER QRCODE
$filesQR = glob('../../qrcode/*.png');
foreach ($filesQR as $fileQR) {
    if (is_file($fileQR))
        unlink($fileQR);
}

$filesPdf = glob('view/nasabah/*.pdf');
foreach ($filesPdf as $filePdf) {
    if (is_file($filePdf))
        unlink($filePdf);
}

$filesPdf = glob('../validate/view/tabungan/*.pdf');
foreach ($filesPdf as $filePdf) {
    if (is_file($filePdf))
        unlink($filePdf);
}


?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <?php require('./layout/headerpage.php'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">

                    <?php
                    //echo $username . "<br>";
                    //echo $tahun . "<br>";
                    //echo $iduser . "<br>";
                    //echo $level . "<br>";
                    //echo $tahun_open;

                    echo $classTabungan->validTahun($tahun);
                    ?>
                </div><!-- /.col -->
                <div class="col-sm-6">

                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Info boxes -->
            <div class="row">
                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-info elevation-1"><i class="bi bi-calendar2"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Saldo Awal</span>
                            <span class="info-box-number">
                                <?php echo $format->ribuan($totalSaldoAWal); ?>
                                <small></small>
                            </span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->
                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-success elevation-1"><i class="bi bi-cash-coin"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Debet</span>
                            <span class="info-box-number"> <?php echo $format->ribuan($totalDebet); ?></span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->

                <!-- fix for small devices only -->
                <div class="clearfix hidden-md-up"></div>

                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-shopping-cart"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Kredit</span>
                            <span class="info-box-number"><?php echo $format->ribuan($totalKredit); ?></span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->
                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-warning elevation-1"><i class="bi bi-coin"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Saldo Akhir</span>
                            <span class="info-box-number"><?php echo $format->ribuan($totalSaldoAkhir); ?></span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card  my-2">

                        <div class="timeline-header bg-primary pt-2 pb-2">
                            <b class="text-light judul my-3 mx-2"><span class="bi bi-card-list"></span> Kas Hari Ini</b>
                        </div>

                        <!-- /.card-header -->

                        <div class="row">
                            <div class="col-md-7">
                                <div class="card-body">
                                    <?php include "beranda/tabel_penerima.php"; ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card-body">

                                    <?php include "beranda/kas.php";
                                    ?>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card-body">
                                    <iframe src="../../asset/bootstrap/plugins/jam/jam4.html" height="230" width="230" frameborder="0"></iframe>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>
            <div class="row mt-3">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title small">Grafik Transaksi</h6>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>

                                <button type="button" class="btn btn-tool" data-card-widget="remove">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <p class="text-center">
                                        <strong>Grafik Debet, Kredit, Saldo Akhir</strong>
                                    </p>
                                    <div class="card-body">
                                        <div class="chart">
                                            <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                        </div>
                                    </div>
                                    <!-- /.chart-responsive -->
                                </div>
                                <!-- /.col -->

                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- ./card-body -->

                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="card  my-2">

                        <div class="timeline-header bg-success pt-2 pb-2">
                            <b class="text-light judul my-3 mx-2"><span class="bi bi-card-list"></span> Daftar Transaksi Debet</b>
                        </div>

                        <!-- /.card-header -->

                        <div class="row">
                            <div class="col-md-12">
                                <div class="card-body">
                                    <?php include "beranda/transaksi_debet.php"; ?>
                                </div>
                            </div>


                        </div>

                    </div>

                </div>
                <div class="col-md-6">
                    <div class="card  my-2">

                        <div class="timeline-header bg-danger pt-2 pb-2">
                            <b class="text-light judul my-3 mx-2"><span class="bi bi-card-list"></span> Daftar Transaksi Kredit</b>
                        </div>

                        <!-- /.card-header -->

                        <div class="row">
                            <div class="col-md-12">
                                <div class="card-body">
                                    <?php include "beranda/transaksi_Kredit.php"; ?>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>


        </div>
        <!--/. container-fluid -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->