<?php
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);


if (isset($_POST['buku'])) {
    $buku = $_POST['buku'];
    $classLap = new simakom_laporan();
    $v_buku = $classLap->jenisBuku($buku);
} else {
    $buku = 1;
    $classLap = new simakom_laporan();
    $v_buku = $classLap->jenisBuku($buku);
};

if (isset($_POST['tanggal'])) {
    $tanggal = $_POST['tanggal'];
} else {
    $classTime = new time();
    $tanggal =  $classTime->getDateInput();
};
$format = new format();
$tanggalBuku = $format->dateToEng($tanggal);

$optVal = new lembaga();
if (isset($_POST['bulan'])) {
    $bulan = $_POST['bulan'];
    $v_bulan = $optVal->ValPeriode($bulan, $tahun1, $tahun2);
} else {
    $bulan = "";
    $v_bulan = $optVal->ValPeriode('1', $tahun1, $tahun2);
};


?>
<!--/ Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta.-->

<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row  mx-0 pr-3">
            <div class="col-12">
                <div class="col-12 ">
                    <div class="card  mx-0">
                        <div class="timeline-header bg-primary  py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-journal-text"></span> Laporan Buku Kas </b>
                        </div>

                        <div class="row col-md-12">
                            <div class="col-md-6">
                                <div class="card-body mt-4 px-1 mx-2">

                                    <div class="row">
                                        <div class="col-12 col-sm-6 col-md-12">
                                            <div class="info-box mb-3">


                                                <div class="info-box-content">
                                                    <div class="relative mb-0 pb-4">
                                                        <input name="judul" value="PARAMETER" style="background-color: gainsboro;" class="form-control-sm col-sm-2 fontInput small bg-default mt-3 text-center" disabled>
                                                    </div>

                                                    <div class="col-sm-12 invoice-col pt-0">

                                                        <form action="" method="post">
                                                            <div class="row">

                                                                <label class="col-sm-3 col-form-label">Jenis Buku </label>
                                                                <div class="col-md-9">
                                                                    <select name="buku" class="form-control form-control-sm fontInput small" onchange="this.form.submit()" required>

                                                                        <option value="<?php echo $buku; ?>"><?php echo $v_buku; ?></option>
                                                                        <option value="1">Buku Kas Umum</option>
                                                                        <option value="2">Buku Pembantu Kas Tunai</option>
                                                                        <option value="3">Buku Pembantu Kas Bank</option>
                                                                        <option value="4">Buku Pembantu Pajak</option>

                                                                    </select>
                                                                </div>

                                                            </div>

                                                            <div class="row">
                                                                <label class="col-sm-3 col-form-label">Periode Bulan</label>
                                                                <div class="col-md-9">
                                                                    <select name="bulan" class="form-control form-control-sm fontInput small" onchange="this.form.submit()">

                                                                        <option value="<?php echo $bulan; ?>"><?php echo $v_bulan; ?></option>
                                                                        <?php
                                                                        $oplist = $optVal->listPeriode($tahun1, $tahun2);
                                                                        echo $oplist;
                                                                        ?>
                                                                    </select>
                                                                </div>

                                                            </div>
                                                            <div class="row">

                                                                <label class="col-sm-3 col-form-label">Tanggal Buku</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-sm fontInput small d-inline" onchange="this.form.submit()" style="text-align:center" pattern="\d{2,2}-\d{2,2}-\d{4}" id="tanggal1" name="tanggal" value="<?php echo $tanggal;

                                                                                                                                                                                                                                                                        ?>" <?php
                                                                                                                                                                                                                                                                            $oldClass = new old();
                                                                                                                                                                                                                                                                            $bukti = $oldClass->showOld('tanggal'); ?> />
                                                                </div>

                                                            </div>

                                                            <div class="row mt-3">
                                                                <label class="col-sm-3 col-form-label"></label>
                                                                <div class="col-md-9">
                                                                    <button type="submit" class="btn btn-primary btn-xs float-left px-2 mx-1" name="save"><i class="bi-funnel"></i> <b>FILTER</b></button>
                                                        </form>

                                                        <?php echo $link->exportXlsxBuku('laporan/buku/print_excel', $tahun,  $buku, $bulan, $tanggal); ?>

                                                        <form name="cetak" action="<?php echo $link->pageAction('laporan/buku/print_preview'); ?>" method="post">
                                                            <input name="tahun" value="<?php echo $tahun; ?>" hidden>
                                                            <input name="buku" value="<?php echo $buku; ?>" hidden>
                                                            <input name="bulan" value="<?php echo $bulan; ?>" hidden>
                                                            <input name="tanggal" value="<?php echo $tanggal; ?>" hidden>
                                                            <button type="submit" class="btn btn-primary btn-xs float-right px-2 mx-1 d-inline"><i class="bi bi-printer"></i><b> CETAK</b></button>
                                                        </form>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="card-body mt-4 px-1 mx-2">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-md-12">
                                    <div class="info-box">

                                        <div class="info-box-content">
                                            <div class="relative mb-1 pb-4">
                                                <input name="judul" value="SUMMARY" style="background-color: gainsboro;" class="form-control-sm col-sm-2 fontInput small bg-default mt-3 text-center" disabled>
                                            </div>

                                            <?php echo $classLap->summary($tb_transaksi, $bulan, $tahun, $tanggalBuku);; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card-body mx-1">
            <label>
                <h6><b class="text-primary">DATA TRANSAKSI BUKU <?php if ($buku == 1) {
                                                                    echo "KAS UMUM";
                                                                } elseif ($buku == 2) {
                                                                    echo "PEMBANTU KAS TUNAI";
                                                                } elseif ($buku == 3) {
                                                                    echo "PEMBANTU KAS BANK";
                                                                } elseif ($buku == 4) {
                                                                    echo "PEMBANTU PAJAK";
                                                                }; ?></b></h6>
            </label>
            <table id="example51" class="table table-bordered table-striped table-hover table-sm mb-4">
                <thead>
                    <tr>
                        <?php
                        if ($buku == 4) {
                            echo  "
                            <th>No</th>
                            <th>No. Bukti</th>
                            <th>Tanggal</th>
                            <th>Uraian</th>
                            <th>PPh Ps 21</th>
                            <th>PPh Ps 22</th>
                            <th>PPh Ps 23</th>
                            <th>PPh Ps 4</th>
                            <th>PPN</th>
                            <th>Kredit</th>
                            <th>Saldo</th>";
                        } else {
                            echo "
                            <th>No</th>
                            <th>No. Bukti</th>
                            <th>Tanggal</th>
                            <th>Uraian</th>
                            <th>Debet</th>
                            <th>Kredit</th>
                            <th>Saldo</th>";
                        }
                        ?>

                    </tr>
                </thead>
                <tbody>

                    <?php
                    $classLap = new simakom_laporan();
                    $format = new format;
                    //$tanggalkonv = $format->dateToEng($tanggal);
                    if ($buku == 1) {
                        $showList = $classLap->list_bku($tb_transaksi, $bulan, $tahun, $tanggalBuku);
                    } elseif ($buku == 2) {
                        $showList = $classLap->list_bukuTunai($tb_transaksi, $bulan, $tahun);
                    } elseif ($buku == 3) {
                        $showList = $classLap->list_bukuBank($tb_transaksi, $bulan, $tahun);
                    } elseif ($buku == 4) {
                        $showList = $classLap->list_bukuPajak($tb_transaksi, $bulan, $tahun);
                    } else {
                        echo "";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>