<?php
$clssimakom_grafik = new simakom_grafik;
$saBKU = $clssimakom_grafik->valuesSABKU($tb_transaksi, $tahun);
$saTunai = $clssimakom_grafik->valuesSATunai($tb_transaksi, $tahun);
$saBank = $clssimakom_grafik->valuesSABank($tb_transaksi, $tahun);
$saPajak = $clssimakom_grafik->valuesSAPajak($tb_transaksi, $tahun);
$saPiutang = $clssimakom_grafik->valuesSAPiutang($tb_transaksi, $tahun);
$saHutang = $clssimakom_grafik->valuesSAHutang($tb_transaksi, $tahun);
?>

<div id="container" style="width: 100%;">
	<canvas class="img-responsive" id="canvas"></canvas>
	<i style="font-size:9px; font-family:arial color=green">Copyright (c) 2018 Chart.js Contributors</i>
</div>

<script>
	var chartData = {
		labels: ['Jul', 'Agt', 'Sep', 'Okt', 'Nop', 'Des', 'Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun'],
		datasets: [

			{
				type: 'line',
				label: 'BKU',
				borderColor: window.chartColors.orange,
				borderWidth: 3,
				fill: false,
				data: [<?php echo $saBKU; ?>],
			},
			{
				type: 'line',
				label: 'Kas Tunai',
				borderColor: window.chartColors.yellow,
				borderWidth: 2,
				fill: false,
				data: [<?php echo $saTunai; ?>],
			},
			{
				type: 'line',
				label: 'Kas Bank',
				borderColor: window.chartColors.blue,
				borderWidth: 2,
				fill: false,
				data: [<?php echo $saBank; ?>],
			},
			{
				type: 'line',
				label: 'Kas BP Pajak',
				borderColor: window.chartColors.purple,
				borderWidth: 2,
				fill: false,
				data: [<?php echo $saPajak; ?>],
			},
			{
				type: 'bar',
				label: 'Piutang',
				backgroundColor: window.chartColors.green,
				data: [<?php echo $saPiutang; ?>],
				borderColor: '',
				borderWidth: 2
			},
			{
				type: 'bar',
				label: 'Hutang',
				backgroundColor: window.chartColors.red,
				data: [<?php echo $saHutang; ?>],
				borderColor: '',
				borderWidth: 2
			}
		]


	};
	window.onload = function() {
		var ctx = document.getElementById('canvas').getContext('2d');
		window.myMixedChart = new Chart(ctx, {
			type: 'bar',
			data: chartData,
			options: {
				responsive: true,
				title: {
					display: true,
					text: 'Grafik Saldo Kas Berdasar Buku [x 1.000.000]'
				},
				tooltips: {
					mode: 'index',
					intersect: true
				}
			}
		});
	};

	document.getElementById('randomizeData').addEventListener('click', function() {
		chartData.datasets.forEach(function(dataset) {
			dataset.data = dataset.data.map(function() {
				return randomScalingFactor();
			});
		});
		window.myMixedChart.update();
	});
</script>