<?php

spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';

$clssekolah = new sekolah;
$classtr = new transaksi;
$classLaporan = new laporan();
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);
$tahunnow = date("Y", $tanggal);

if (isset($_GET['tahun'])) {
    $tahun = $_GET['tahun'];
} else {
    $tahun = $tahunnow;
};
$tahun1 = substr($tahun, 0, 4);
$tahun2 = substr($tahun, 5, 4);

$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_transaksi = "db_transaksi" . $tahun_tabel;



if (isset($_GET['tgl_1'])) {
    $tgl_1 = $_GET['tgl_1'];
} else {
    $tgl_1 = $tglsekarang;
};
if (isset($_GET['tgl_2'])) {
    $tgl_2 = $_GET['tgl_2'];
} else {
    $tgl_2 = $tglsekarang;
};
if (isset($_GET['penerima_lap']) && $_GET['penerima_lap'] != 'Semua') {
    $penerima_lap = $_GET['penerima_lap'];
    $penerima_filter = "and penerima='$penerima_lap'";
} else {
    $penerima_lap = "Semua";
    $penerima_filter = "";
};
if (isset($_GET['jenjang_lap'])  && $_GET['jenjang_lap'] != 'Semua') {
    $jenjang_lap = $_GET['jenjang_lap'];
    $jenjang_filter = "and jenjang='$jenjang_lap'";
} else {
    $jenjang_lap = "Semua";
    $jenjang_filter = "";
};
if (isset($_GET['paralel_lap'])  && $_GET['paralel_lap'] != 'Semua') {
    $paralel_lap = $_GET['paralel_lap'];
    $paralel_filter = "and paralel='$paralel_lap'";
} else {
    $paralel_lap = "Semua";
    $paralel_filter = "";
};
if (isset($_GET['metode_lap'])  && $_GET['metode_lap'] != 'Semua') {
    $metode_lap = $_GET['metode_lap'];
    $metode_filter = "and metode='$metode_lap'";
} else {
    $metode_lap = "Semua";
    $metode_filter = "";
};

//$showList = $crud->showTable($tb_transaksi . " WHERE tanggal>='$tgl1' and tanggal<='$tgl2' $penerima_filter $metode_filter $jenjang_filter $paralel_filter");

$val_penerima = $classtr->namaPenerimaByID($penerima_lap);

$format = new format();


header("Content-type: text/csv");
header("Content-Disposition: attachment; filename=TRANSAKSI_" . $tgl_1 . ' s.d ' . $tgl_2 . ".txt");
header("Pragma: no-cache");
header("Expires: 0");

echo  "No|Tanggal|Nama|NIS|Kelas|Kode Jenis|Nama Jenis Pembayaran|Periode|Jumlah|Metode";
echo "\n";

$tgl1 = $format->dateToEng($tgl_1);
$tgl2 = $format->dateToEng($tgl_2);

$crud = new crudData();
$showList = $crud->showTable($tb_transaksi . " WHERE tanggal>='$tgl1' and tanggal<='$tgl2' $penerima_filter $metode_filter $jenjang_filter $paralel_filter");

$count_trn = $showList->rowCount();
$no = 1;

while ($data = $showList->fetch(PDO::FETCH_OBJ)) {


    if ($data->jumlah == "" || $data->jumlah == 0) {
        // $jumlah = number_format(0, 2, ",", ".");
        $jumlah = 0;
    } else {
        //$jumlah = number_format($data->jumlah, 2, ",", ".");
        $jumlah = $data->jumlah;
    };
    if ($data->setor == "Ya") {
        $setor = "Disetor";
    } else {
        $setor = "--";
    };
    $nis = $data->nis;
    $tahap = $data->tahap;
    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    //startAt
    $classTr = new transaksi();
    $startAt = $classTr->startAt($tb_siswa, $nis);
    $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    $showJenis = $classNB->shownamaBayar($tahun, $data->jenis, $data->jenjang);
    $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
    $field_tang = 'tang_' . $datajenis->kode;
    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

    if ($setbulanan == "Tidak") {
        $periode = "Tahap " . $tahap;
    } else {
        $periode = $cekbulan;
    };

    $penerima = $classTr->namaPenerimaByID($data->penerima);


    echo $no . '|' . $data->tanggal . '|' . $format->entityEncode($data->nama) . '|' . $nis . '|' . $data->jenjang . '-' . $data->paralel . '|' . $data->jenis . '|' . $ceknamaBayar . '|' . $periode . '|' . $data->jumlah . '|' . $data->metode;

    echo "\n";



    $no++; // Tambah 1 setiap kali looping

    // $row++; // Tambah 1 setiap kali looping

};
