<?php
require "../../../asset/mod/autoLoad.php";
require "../layout/session.php";

$grafik = new aks_grafik;
$realisasi = $grafik->realisasiBulan($tb_transaksi, $tahun);
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="<?php
				$logo = new dirImage;
				echo $logo->dirImg('../dokumen/foto/', 'logo');
				?>" rel='shortcut icon'>

	<title>AKS || <?php echo $clasSekolah->dataSekolah('sekolah'); ?></title>

	<link rel="stylesheet" href="../../../asset/bootstrap/css/adminlte.min.css">
	<script src="../../../asset/bootstrap/plugins/chart/dist/Chart.bundle.js"></script>
	<script src="../../../asset/bootstrap/plugins/chart/utils.js"></script>
	<style>
		.loader {
			background-color: white;
			opacity: 0.7;
			margin: auto;
			z-index: 99999999;
			-webkit-animation: spin 2s linear infinite;
			animation: spin 2s linear infinite;
		}
	</style>
</head>
<div id="container" style="width: 100%;">
	<canvas class="img-responsive" id="canvas1"></canvas>
	<i style="font-size:9px; font-family:arial color=green">Copyright (c) 2018 Chart.js Contributors</i>
</div>

<script>
	var chartDataBulan = {
		labels: ['Pre', 'Jul', 'Agt', 'Sep', 'Okt', 'Nop', 'Des', 'Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Paska'],
		datasets: [

			<?php
			$crud = new crudData;
			$jenjang = strtolower($crud->getValue('sekolah', "where no>0", 'jenjang'));
			$opt = new form();
			$opval = $opt->optSelect('tb_tingkat', "where {$jenjang}<>'' order by no asc");
			while ($dataopt = $opval->fetch(PDO::FETCH_OBJ)) {
				$v_jenjang = $dataopt->{$jenjang};
				$tingkat = $dataopt->tingkat;
				//$val = $grafik->realisasiBulanperJenjang($tb_transaksi, $tahun, $v_jenjang);
				$color = $grafik->lineColor($tingkat);
				echo $grafik->chartBulanperJenjang($tb_transaksi, $tahun, $v_jenjang, $color);
			};

			?>

			{
				type: 'bar',
				label: 'Penerimaan',
				backgroundColor: window.chartColors.grown,
				data: [<?php echo $realisasi; ?>],
				borderColor: '',
				borderWidth: 2
			}
		]

	};
	window.onload = function() {
		var ctx = document.getElementById('canvas1').getContext('2d');
		window.myMixedChart = new Chart(ctx, {
			type: 'bar',
			data: chartDataBulan,
			options: {
				responsive: true,
				title: {
					display: true,
					text: ''
				},
				tooltips: {
					mode: 'index',
					intersect: true
				}
			}
		});
	};
	document.getElementById('randomizeData').addEventListener('click', function() {
		chartData.datasets.forEach(function(dataset) {
			dataset.data = dataset.data.map(function() {
				return randomScalingFactor();
			});
		});
		window.myMixedChart.update();
	});
</script>