DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text DEFAULT NULL,
  `notice2` text DEFAULT NULL,
  `tk` text DEFAULT NULL,
  `tp` varchar(10) NOT NULL,
  `webaddress` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `webaddress`, `id`) VALUES
	(1,'MAN 4 BOGOR','','','SMA','','','','','primary','','','primary','','','1','1','2024-08-28','','','','','','','','','','','','','','','TERIMA KASIH','2023/2024','','5E9496B348D8CB2DA2869F4AF7704C3F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'MAN 4 BOGOR','94E685-5677BS-85E109-7BD685-CF4BF0','87BBAF142567EB71C68E371CE653509B016E67EFC04D901EC5A','2024-08-28','5E9496B348D8CB2DA2869F4AF7704C3F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Drs. Cece Kamalusolihin','L','tje2kamal@gmail.com','08568130011','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','33514ba1c34ae2804af076c4fd3e8603'),
	(26,'d0f83653fdb01ed928a4','Siti','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','d0f83653fdb01ed928a4'),
	(27,'606ef979469528e637f6','Khumairah','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','606ef979469528e637f6'),
	(28,'4bc2be4245c022748235','Ahmad','L','','','kepala','870f669e4bbbfa8a6fde65549826d1c4','monitoring','Aktif','4bc2be4245c022748235'),
	(29,'6088971c048fb45e4317','Nisa','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','6088971c048fb45e4317');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(19,'A','100202','100202','Pendapatan Sewa GOR','be9bbf8e7cb2de034bee59162bafcaaefb0'),
	(17,'A','100103','100103','Penerimaan Biaya Akomodasi MMP','9ae26ff44c264acbcdb9f37bb5c08fcc9f9'),
	(18,'A','100201','100201','Pendapatan Ternak Ikan','7c7523f13ef609d154a6ac2187a5c8735fa'),
	(13,'A','100000','100000','Penerimaan Saldo Tahun Lalu','14ee22eaba29794682775be85f192af3021'),
	(14,'A','100101','100101','Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102','Penerimaan Sumbangan Pengembangan Sekolah','54ebda338d716823ef59a48ec57a173850c'),
	(16,'A','100104','100104','Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(20,'B','200101','200101','Belanja Honorarium Guru Tidak Tetap','fae1f94c506115ec42df2a0fd12dbe9c7aa'),
	(21,'B','200102','200102','Belanja Honorarium Pegawai Tidak Tetap','bc0db1ef7e8b6388b70ac689b02eee2cda0'),
	(22,'B','200103','200103','Belanja Honorarium Pembina Ekstra Internal','bd0b3e43c34a47ccdb67d115df7de21d9b8'),
	(23,'B','200104','200104','Belanja Honorarium Pembina Ekstra Eksternal','dde4acfdb0be07ac132ad5a295fc9f4b8ad'),
	(24,'B','200201','200201','Belanja Pemeliharaan Gedung dan Bangunan','fafe0a5ad92e1f86d2c833d5982ea8d01c1'),
	(25,'B','200202','200202','Belanja Pemeliharaan Peralatan dan Mesin','452bfed404cb95dbfaadfd1aa56e52d612a'),
	(26,'B','200301','200301','Belanja Keperluan Perkantoran','8aee09e623dfe2f7d11e4d0ad60d0a5ca38'),
	(27,'B','200302','200302','Belanja Bahan','004ca31ed6cc0360fe946d3365893f2b99d'),
	(28,'B','200401','200401','Belanja Jasa Profesi','9756342aa9434be8f1e85b87a4163c6354d'),
	(29,'B','200402','200402','Belanja Sewa','800d427f7b19cf62174b86e51875116f576'),
	(30,'B','200403','200403','Belanja Langganan Daya dan Jasa','de345b20a5d60aecea768241b2e0d2fcb0d'),
	(42,'B','200107','200107','Belanja Honorarium THR Guru Tidak Tetap','6752ca88e78474b7acd301cfefc889b658a'),
	(41,'B','200106','200106','Belanja Penunjang Kegiatan Pendidikan','7a303a097dd4e0259280330a6809291f824'),
	(34,'B','299999','299999','Belanja Lainnya','94cfaff110fc98938230b1e4e53541cfbc5'),
	(35,'B','200105','200105','Belanja Honor Kegiatan','e085d8a5248ec1cee089e4a2bff2e804231'),
	(36,'A','100301','100301','Bantuan Operasional Sekolah (BOS)','a6061a0c10b13bf137460ec8e143a214b05'),
	(37,'A','199999','199999','Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105','Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(39,'B','200501','200501','Belanja Perjaanan Dinas','269727a2b342292f278b69e51643ea9e1b8'),
	(40,'B','200210','200210','Belanja Pengadaan Tanah','71464592903d1ac6bfb8cdcfed812c0c969'),
	(43,'B','200108','200108','Belanja Honorarium THR Pegawai Tidak Tetap','1fdbafb8171bc612ee72f9fa507f8e4fa32'),
	(44,'B','200109','200109','Belanja Honorarium Ke-13 Guru Tidak Tetap','b746153e7a27362c6c611539f2d9acd0094'),
	(45,'B','200110','200110','Belanja Honorarium Ke-13 Pegawai Tidak Tetap','f234d714e94e229d926d70b864ce568ad54'),
	(46,'B','200111','200111','Belanja Tunjangan Reward Kehadiran Guru Tidak Tetap','6e59975fd49e3d83bcf5381468064911efa'),
	(47,'B','200112','200112','Belanja Tunjangan Reward Kehadiran Pegawai Tidak Tetap','8655f16996c8058e106e2bc0ab56d9a4f0b'),
	(48,'B','200113','200113','Belanja Honorarium Petugas Piket Hari Libur','d6155c6ec9d14c2bdc408fb3fe9db1bfa3e'),
	(49,'A','100302','100302','Uang Kegiatan','8acdf12cd77f6e7b488840a65a20ab6e33d');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617682775be85f192af3021','A','1000','1000','Penerimaan Saldo Tahun Lalu'),
	(113,'b8c37e33defde51c9354242c284f97a5e37','A','1001','1001','Penerimaan Sumbangan Masyarakat'),
	(114,'5ec829debe54b19f0c285f19d5f8238d516','A','1999','1999','Penerimaan Lain'),
	(115,'fba9d88164f3e2d96797f48c50918cfed34','A','1002','1002','Penerimaan Pendapatan Asli sekolah'),
	(116,'08f90c1a41715538b72664c9498459011e6','B','2000','2000','Belanja Kegiatan Standar Kelulusan'),
	(117,'d0fb963ff976f9c653181e9d8ca9683b483','B','2001','2001','Belanja Kegiatan Standar Isi'),
	(118,'4ba29b9f9e5732ec04affa66cf010b62572','B','2002','2002','Belanja Kegiatan Standar Proses'),
	(119,'a591024321c5e2b16506375d817b0241e6f','B','2003','2003','Belanja Kegiatan Standar Pengelolaan'),
	(120,'b8b4b727d6f5d1b10479106d6c3105ea2a5','B','2004','2004','Belanja Kegiatan Standar Tendik'),
	(121,'d47268e9db2e9aa32fc56790236f069da49','B','2005','2005','Belanja Kegiatan Standar Pembiayaan'),
	(122,'ea5a486c712a91eb215f8699c222f811cdc','B','2006','2006','Belanja Kegiatan Standar Sarana Prasarana'),
	(123,'a00e5eb0973d2463c5686760dfed4295acd','B','2007','2007','Belanja Kegiatan Standar Penilaian'),
	(124,'aa68c75c4a77c870bcef3a2582241da86d0','A','1003','1003','Penerimaan Uang Kegiatan'),
	(125,'a36e841c5230a796600fd02a16301a5fb97','B','2999','2999','Belanja Lain-lain');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','11'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','12'),
	(34,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B10','','10'),
	(35,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B8','','11'),
	(36,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B9','','12'),
	(53,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C8','','11'),
	(54,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C9','','12'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALulus','','LULUS'),
	(62,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C7','','10');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','B','Aktif'),
	(21,'0d61f8370cad82c486547f599','C','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','A','Aktif'),
	(24,'f623e75af30e6f2052d0bd5ba','D','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','E','Aktif'),
	(26,'800618943025ed73eb5b6b972','F','Aktif'),
	(27,'dfcf28d07345df1fb088c98f0','G','Aktif'),
	(33,'e11c1bc57b97131059d58b826','LULUS','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(6,'KKO','de3ad54b3bd47253639bd484582','2023-07-31 08:45:02');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(13,'2023/2024','','2023-07-10 14:24:48','5531a5834816c3f04945cbc9d','2023-07-10 14:24:48','113ccaa98a0a30bc5204ed2fccc9c515'),
	(16,'2024/2025','','2024-09-08 19:10:33','07811dc6c4222c843f46dd107','2024-09-08 19:10:33','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text DEFAULT NULL,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text NOT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','','','','0','','','0','5E9496B348D8CB2DA2869F4AF7704C3F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(1,'2022/2023','close','2023-04-20 11:33:23','2023-10-03 05:06:19','tabungan','38eafdfa86559e303bd0'),
	(2,'2023/2024','open','2023-04-21 19:57:26','1901-01-01 00:00:00','','da6363e171cecab03bd0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2425`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2425`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2425`;

CREATE TABLE IF NOT EXISTS `simakom_akun2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2425`;

CREATE TABLE IF NOT EXISTS `simakom_detail2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2425`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2425`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2425`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2425`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2425`;

CREATE TABLE IF NOT EXISTS `db_setor2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2425`;

CREATE TABLE IF NOT EXISTS `payment_list2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `payment_set` (`no`, `aktif`, `sistem`, `api`, `callback`, `fee`, `id`) VALUES
	(1,'','','','','0','5E9496B348D8CB2DA2869F4AF7704C3F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2425`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2425`;

CREATE TABLE IF NOT EXISTS `db_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2425`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

